/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.parser;

import ca.uhn.hl7v2.parser.EncodingCharacters;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class Escape {
    private static Map<EncodingCharacters, EncLookup> variousEncChars = Collections.synchronizedMap(new LinkedHashMap<EncodingCharacters, EncLookup>(5, 0.75f, true){
        private static final long serialVersionUID = 1L;
        final int maxSize = new Integer(System.getProperty(String.valueOf(Escape.class.getName()) + ".maxSize", "1000"));

        @Override
        protected boolean removeEldestEntry(Map.Entry<EncodingCharacters, EncLookup> eldest) {
            return this.size() > this.maxSize;
        }
    });

    public static String escape(String text, EncodingCharacters encChars) {
        EncLookup esc = Escape.getEscapeSequences(encChars);
        int textLength = text.length();
        StringBuilder result = new StringBuilder(textLength);
        int i = 0;
        while (i < textLength) {
            boolean charReplaced = false;
            char c = text.charAt(i);
            int j = 0;
            while (j < 6) {
                if (text.charAt(i) == esc.characters[j]) {
                    int nextEscapeIndex;
                    if (j == 4 && i + 1 < textLength && text.charAt(i + 1) == '.' && (nextEscapeIndex = text.indexOf(esc.characters[j], i + 1)) > 0) {
                        result.append(text.substring(i, nextEscapeIndex + 1));
                        charReplaced = true;
                        i = nextEscapeIndex;
                        break;
                    }
                    result.append(esc.encodings[j]);
                    charReplaced = true;
                    break;
                }
                ++j;
            }
            if (!charReplaced) {
                result.append(c);
            }
            ++i;
        }
        return result.toString();
    }

    public static String unescape(String text, EncodingCharacters encChars) {
        char escapeChar = encChars.getEscapeCharacter();
        boolean foundEscapeChar = false;
        int i = 0;
        while (i < text.length()) {
            if (text.charAt(i) == escapeChar) {
                foundEscapeChar = true;
                break;
            }
            ++i;
        }
        if (!foundEscapeChar) {
            return text;
        }
        int textLength = text.length();
        StringBuilder result = new StringBuilder(textLength + 20);
        EncLookup esc = Escape.getEscapeSequences(encChars);
        char escape = esc.characters[4];
        int encodingsCount = esc.characters.length;
        int i2 = 0;
        while (i2 < textLength) {
            char c = text.charAt(i2);
            if (c != escape) {
                result.append(c);
                ++i2;
                continue;
            }
            boolean foundEncoding = false;
            int j = 0;
            while (j < encodingsCount) {
                String encoding = esc.encodings[j];
                int encodingLength = encoding.length();
                if (i2 + encodingLength <= textLength && text.substring(i2, i2 + encodingLength).equals(encoding)) {
                    result.append(esc.characters[j]);
                    i2 += encodingLength;
                    foundEncoding = true;
                    break;
                }
                ++j;
            }
            if (foundEncoding) continue;
            if (i2 + 1 < textLength && text.charAt(i2 + 1) == '.') {
                int closingEscape = text.indexOf(escape, i2 + 1);
                if (closingEscape > 0) {
                    String substring = text.substring(i2, closingEscape + 1);
                    result.append(substring);
                    i2 += substring.length();
                    continue;
                }
                ++i2;
                continue;
            }
            ++i2;
        }
        return result.toString();
    }

    private static EncLookup getEscapeSequences(EncodingCharacters encChars) {
        EncLookup escapeSequences = variousEncChars.get(encChars);
        if (escapeSequences == null) {
            escapeSequences = new EncLookup(encChars);
            variousEncChars.put(encChars, escapeSequences);
        }
        return escapeSequences;
    }

    private static class EncLookup {
        char[] characters = new char[6];
        String[] encodings = new String[6];

        EncLookup(EncodingCharacters ec) {
            this.characters[0] = ec.getFieldSeparator();
            this.characters[1] = ec.getComponentSeparator();
            this.characters[2] = ec.getSubcomponentSeparator();
            this.characters[3] = ec.getRepetitionSeparator();
            this.characters[4] = ec.getEscapeCharacter();
            this.characters[5] = 13;
            char[] codes = new char[]{'F', 'S', 'T', 'R', 'E'};
            int i = 0;
            while (i < codes.length) {
                StringBuffer seq = new StringBuffer();
                seq.append(ec.getEscapeCharacter());
                seq.append(codes[i]);
                seq.append(ec.getEscapeCharacter());
                this.encodings[i] = seq.toString();
                ++i;
            }
            this.encodings[5] = "\\X000d\\";
        }
    }
}

