/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.parser;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.VersionLogger;
import ca.uhn.hl7v2.model.GenericMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Segment;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.EncodingCharacters;
import ca.uhn.hl7v2.parser.EncodingNotSupportedException;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.validation.MessageValidator;
import ca.uhn.hl7v2.validation.ValidationContext;
import ca.uhn.hl7v2.validation.ValidationException;
import ca.uhn.hl7v2.validation.impl.DefaultValidation;
import ca.uhn.hl7v2.validation.impl.ValidationContextFactory;
import ca.uhn.log.HapiLog;
import ca.uhn.log.HapiLogFactory;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Parser {
    private static final HapiLog log = HapiLogFactory.getHapiLog(Parser.class);
    private static Map<String, Properties> messageStructures = null;
    private ModelClassFactory myFactory;
    private ValidationContext myContext;
    private MessageValidator myValidator;
    private static final List<String> versions = Collections.unmodifiableList(Arrays.asList("2.1", "2.2", "2.3", "2.3.1", "2.4", "2.5", "2.5.1", "2.6"));

    static {
        VersionLogger.init();
    }

    public Parser() {
        this(null);
    }

    public Parser(ModelClassFactory theFactory) {
        ValidationContext validationContext;
        if (theFactory == null) {
            theFactory = new DefaultModelClassFactory();
        }
        this.myFactory = theFactory;
        try {
            validationContext = ValidationContextFactory.getContext();
        }
        catch (ValidationException e) {
            log.warn("Failed to get a validation context from the ValidationContextFactory", e);
            validationContext = new DefaultValidation();
        }
        this.setValidationContext(validationContext);
    }

    public ModelClassFactory getFactory() {
        return this.myFactory;
    }

    public ValidationContext getValidationContext() {
        return this.myContext;
    }

    public void setValidationContext(ValidationContext theContext) {
        this.myContext = theContext;
        this.myValidator = new MessageValidator(theContext, true);
    }

    public abstract String getEncoding(String var1);

    public abstract boolean supportsEncoding(String var1);

    public abstract String getDefaultEncoding();

    public Message parse(String message) throws HL7Exception, EncodingNotSupportedException {
        String encoding = this.getEncoding(message);
        if (!this.supportsEncoding(encoding)) {
            throw new EncodingNotSupportedException("Can't parse message beginning " + message.substring(0, Math.min(message.length(), 50)));
        }
        String version = this.getVersion(message);
        if (!Parser.validVersion(version)) {
            throw new HL7Exception("Can't process message of version '" + version + "' - version not recognized", 203);
        }
        this.myValidator.validate(message, encoding.equals("XML"), version);
        Message result = this.doParse(message, version);
        this.myValidator.validate(result);
        result.setParser(this);
        return result;
    }

    protected abstract Message doParse(String var1, String var2) throws HL7Exception, EncodingNotSupportedException;

    public String encode(Message source, String encoding) throws HL7Exception, EncodingNotSupportedException {
        this.myValidator.validate(source);
        String result = this.doEncode(source, encoding);
        this.myValidator.validate(result, encoding.equals("XML"), source.getVersion());
        return result;
    }

    protected abstract String doEncode(Message var1, String var2) throws HL7Exception, EncodingNotSupportedException;

    public String encode(Message source) throws HL7Exception {
        String encoding = this.getDefaultEncoding();
        this.myValidator.validate(source);
        String result = this.doEncode(source);
        this.myValidator.validate(result, encoding.equals("XML"), source.getVersion());
        return result;
    }

    protected abstract String doEncode(Message var1) throws HL7Exception;

    public abstract Segment getCriticalResponseData(String var1) throws HL7Exception;

    public abstract String getAckID(String var1);

    public abstract String getVersion(String var1) throws HL7Exception;

    public abstract String doEncode(Segment var1, EncodingCharacters var2) throws HL7Exception;

    public abstract String doEncode(Type var1, EncodingCharacters var2) throws HL7Exception;

    public abstract void parse(Type var1, String var2, EncodingCharacters var3) throws HL7Exception;

    public abstract void parse(Segment var1, String var2, EncodingCharacters var3) throws HL7Exception;

    public abstract void parse(Message var1, String var2) throws HL7Exception;

    public static Segment makeControlMSH(String version, ModelClassFactory factory) throws HL7Exception {
        Segment msh = null;
        Object className = null;
        try {
            Message dummy = (Message)GenericMessage.getGenericMessageClass(version).getConstructor(ModelClassFactory.class).newInstance(factory);
            Class[] constructorParamTypes = new Class[]{Group.class, ModelClassFactory.class};
            Object[] constructorParamArgs = new Object[]{dummy, factory};
            Class<? extends Segment> c = factory.getSegmentClass("MSH", version);
            Constructor<? extends Segment> constructor = c.getConstructor(constructorParamTypes);
            msh = constructor.newInstance(constructorParamArgs);
        }
        catch (Exception e) {
            throw new HL7Exception("Couldn't create MSH for version " + version + " (does your classpath include this version?) ... ", 207, e);
        }
        return msh;
    }

    public static boolean validVersion(String version) {
        return versions.contains(version);
    }

    public static List<String> getValidVersions() {
        return versions;
    }

    public static String getMessageStructureForEvent(String name, String version) throws HL7Exception {
        String structure = null;
        if (!Parser.validVersion(version)) {
            throw new HL7Exception("The version " + version + " is unknown");
        }
        Properties p = null;
        try {
            p = Parser.getMessageStructures().get(version);
            if (p == null) {
                throw new HL7Exception("No map found for version " + version + ". Only the following are available: " + Parser.getMessageStructures().keySet());
            }
        }
        catch (IOException ioe) {
            throw new HL7Exception(ioe);
        }
        structure = p.getProperty(name);
        if (structure == null) {
            structure = name;
        }
        return structure;
    }

    public static Properties getMessageStructures(String version) throws IOException {
        Map<String, Properties> msgStructures = Parser.getMessageStructures();
        if (!msgStructures.containsKey(version)) {
            return null;
        }
        return (Properties)msgStructures.get(version).clone();
    }

    private static synchronized Map<String, Properties> getMessageStructures() throws IOException {
        if (messageStructures == null) {
            messageStructures = Parser.loadMessageStructures();
        }
        return messageStructures;
    }

    private static Map<String, Properties> loadMessageStructures() throws IOException {
        HashMap<String, Properties> map = new HashMap<String, Properties>();
        for (String version : versions) {
            String resource = "ca/uhn/hl7v2/parser/eventmap/" + version + ".properties";
            InputStream in = Parser.class.getClassLoader().getResourceAsStream(resource);
            Properties structures = null;
            if (in == null) continue;
            structures = new Properties();
            structures.load(in);
            map.put(version, structures);
        }
        return map;
    }

    protected Message instantiateMessage(String theName, String theVersion, boolean isExplicit) throws HL7Exception {
        Message result = null;
        try {
            Class<? extends Message> messageClass = this.myFactory.getMessageClass(theName, theVersion, isExplicit);
            if (messageClass == null) {
                throw new ClassNotFoundException("Can't find message class in current package list: " + theName);
            }
            log.info("Instantiating msg of class " + messageClass.getName());
            Constructor<? extends Message> constructor = messageClass.getConstructor(ModelClassFactory.class);
            result = constructor.newInstance(this.myFactory);
        }
        catch (Exception e) {
            throw new HL7Exception("Couldn't create Message object of type " + theName, 200, e);
        }
        result.setValidationContext(this.myContext);
        return result;
    }
}

