/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.util;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Segment;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.util.FilterIterator;
import ca.uhn.hl7v2.util.MessageIterator;
import java.util.Iterator;
import java.util.Stack;

public class MessageNavigator {
    private Group root;
    private Stack ancestors;
    private int currentChild;
    private Group currentGroup;
    private String[] childNames;

    public MessageNavigator(Group root) {
        this.root = root;
        this.reset();
    }

    public Group getRoot() {
        return this.root;
    }

    public void drillDown(int childNumber, int rep) throws HL7Exception {
        if (childNumber != -1) {
            Structure s = this.currentGroup.get(this.childNames[childNumber], rep);
            if (!(s instanceof Group)) {
                throw new HL7Exception("Can't drill into segment", 207);
            }
            Group group = (Group)s;
            GroupContext gc = new GroupContext(this.currentGroup, this.currentChild);
            this.ancestors.push(gc);
            this.currentGroup = group;
        }
        this.currentChild = 0;
        this.childNames = this.currentGroup.getNames();
    }

    public void drillDown(int rep) throws HL7Exception {
        this.drillDown(this.currentChild, rep);
    }

    public boolean drillUp() {
        if (!this.ancestors.empty()) {
            GroupContext gc = (GroupContext)this.ancestors.pop();
            this.currentGroup = gc.group;
            this.currentChild = gc.child;
            this.childNames = this.currentGroup.getNames();
            return true;
        }
        if (this.currentChild == -1) {
            return false;
        }
        this.currentChild = -1;
        return true;
    }

    public boolean hasNextChild() {
        return this.childNames.length > this.currentChild + 1;
    }

    public void nextChild() throws HL7Exception {
        int child = this.currentChild + 1;
        this.toChild(child);
    }

    public void toChild(int child) throws HL7Exception {
        if (child < 0 || child >= this.childNames.length) {
            throw new HL7Exception("Can't advance to child " + child + " -- only " + this.childNames.length + " children", 207);
        }
        this.currentChild = child;
    }

    public void reset() {
        this.ancestors = new Stack();
        this.currentGroup = this.root;
        this.currentChild = -1;
        this.childNames = this.currentGroup.getNames();
    }

    public Structure getCurrentStructure(int rep) throws HL7Exception {
        Structure ret = null;
        if (this.currentChild != -1) {
            String childName = this.childNames[this.currentChild];
            ret = this.currentGroup.get(childName, rep);
        } else {
            ret = this.currentGroup;
        }
        return ret;
    }

    public Group getCurrentGroup() {
        return this.currentGroup;
    }

    public Structure[] getCurrentChildReps() throws HL7Exception {
        if (this.currentGroup == this.root && this.currentChild == -1) {
            throw new HL7Exception("Pointer is at root of navigator: there is no current child");
        }
        String childName = this.childNames[this.currentChild];
        return this.currentGroup.getAll(childName);
    }

    public void iterate(boolean segmentsOnly, boolean loop) throws HL7Exception {
        Structure start = null;
        start = this.currentChild == -1 ? this.currentGroup : this.currentGroup.get(this.childNames[this.currentChild]);
        Iterator it = new MessageIterator(start, "doesn't exist", false);
        if (segmentsOnly) {
            FilterIterator.Predicate predicate = new FilterIterator.Predicate(){

                public boolean evaluate(Object obj) {
                    return Segment.class.isAssignableFrom(obj.getClass());
                }
            };
            it = new FilterIterator(it, predicate);
        }
        if (it.hasNext()) {
            Structure next = (Structure)it.next();
            this.drillHere(next);
        } else if (loop) {
            this.reset();
        } else {
            throw new HL7Exception("End of message reached while iterating without loop", 207);
        }
    }

    private void drillHere(Structure destination) throws HL7Exception {
        Structure pathElem = destination;
        Stack<Structure> pathStack = new Stack<Structure>();
        Stack<MessageIterator.Index> indexStack = new Stack<MessageIterator.Index>();
        do {
            MessageIterator.Index index = MessageIterator.getIndex(pathElem.getParent(), pathElem);
            indexStack.push(index);
            pathElem = pathElem.getParent();
            pathStack.push(pathElem);
        } while (!this.root.equals(pathElem) && !Message.class.isAssignableFrom(pathElem.getClass()));
        if (!this.root.equals(pathElem)) {
            throw new HL7Exception("The destination provided is not under the root of this navigator");
        }
        this.reset();
        while (!pathStack.isEmpty()) {
            Group parent = (Group)pathStack.pop();
            MessageIterator.Index index = (MessageIterator.Index)indexStack.pop();
            int child = this.search(parent.getNames(), index.name);
            if (!pathStack.isEmpty()) {
                this.drillDown(child, 0);
                continue;
            }
            this.toChild(child);
        }
    }

    private int search(Object[] list, Object item) {
        int found = -1;
        int i = 0;
        while (i < list.length && found == -1) {
            if (list[i].equals(item)) {
                found = i;
            }
            ++i;
        }
        return found;
    }

    private void findLeaf() throws HL7Exception {
        Class c;
        if (this.currentChild == -1) {
            this.currentChild = 0;
        }
        if (Group.class.isAssignableFrom(c = this.currentGroup.getClass(this.childNames[this.currentChild]))) {
            this.drillDown(this.currentChild, 0);
            this.findLeaf();
        }
    }

    private class GroupContext {
        public Group group;
        public int child;

        public GroupContext(Group g, int c) {
            this.group = g;
            this.child = c;
        }
    }
}

