/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v22.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v22.datatype.CM_OCD;
import ca.uhn.hl7v2.model.v22.datatype.CM_OSP;
import ca.uhn.hl7v2.model.v22.datatype.CM_UVC;
import ca.uhn.hl7v2.model.v22.datatype.ID;
import ca.uhn.hl7v2.model.v22.datatype.SI;
import ca.uhn.hl7v2.model.v22.datatype.ST;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class UB2
extends AbstractSegment {
    public UB2(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, false, 1, 4, new Object[]{this.getMessage(), new Integer(0)}, "Set ID - UB92");
            this.add(ST.class, false, 1, 3, new Object[]{this.getMessage(), new Integer(0)}, "Co-insurance days (9)");
            this.add(ID.class, false, 7, 2, new Object[]{this.getMessage()}, "Condition code (24-30)");
            this.add(ST.class, false, 1, 3, new Object[]{this.getMessage(), new Integer(0)}, "Covered days (7)");
            this.add(ST.class, false, 1, 4, new Object[]{this.getMessage(), new Integer(0)}, "Non-covered days (8)");
            this.add(CM_UVC.class, false, 12, 11, new Object[]{this.getMessage(), new Integer(0)}, "Value amount and code (39-41)");
            this.add(CM_OCD.class, false, 8, 11, new Object[]{this.getMessage(), new Integer(0)}, "Occurrence code and date (32-35)");
            this.add(CM_OSP.class, false, 2, 28, new Object[]{this.getMessage(), new Integer(0)}, "Occurrence span code / dates (36)");
            this.add(ST.class, false, 2, 29, new Object[]{this.getMessage(), new Integer(0)}, "UB92 locator 2 (state)");
            this.add(ST.class, false, 2, 12, new Object[]{this.getMessage(), new Integer(0)}, "UB92 locator 11 (state)");
            this.add(ST.class, false, 1, 5, new Object[]{this.getMessage(), new Integer(0)}, "UB92 locator 31 (national)");
            this.add(ST.class, false, 3, 23, new Object[]{this.getMessage(), new Integer(0)}, "Document control number (37)");
            this.add(ST.class, false, 23, 4, new Object[]{this.getMessage(), new Integer(0)}, "UB92 locator 49 (national)");
            this.add(ST.class, false, 5, 14, new Object[]{this.getMessage(), new Integer(0)}, "UB92 locator 56 (state)");
            this.add(ST.class, false, 1, 27, new Object[]{this.getMessage(), new Integer(0)}, "UB92 locator 57 (national)");
            this.add(ST.class, false, 2, 2, new Object[]{this.getMessage(), new Integer(0)}, "UB92 Locator 78 (state)");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error creating UB2 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public SI getSetIDUB92() {
        SI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (SI)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public SI getUb21_SetIDUB92() {
        SI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (SI)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST getCoInsuranceDays9() {
        ST ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST getUb22_CoInsuranceDays9() {
        ST ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ID[] getConditionCode2430() {
        ID[] ret = null;
        try {
            Type[] t = this.getField(3);
            ret = new ID[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (ID)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ID getConditionCode2430(int rep) {
        ID ret = null;
        try {
            Type t = this.getField(3, rep);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ID getUb23_ConditionCode2430(int rep) {
        ID ret = null;
        try {
            Type t = this.getField(3, rep);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ID insertConditionCode2430(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(3, rep);
    }

    public ID insertUb23_ConditionCode2430(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(3, rep);
    }

    public ID removeConditionCode2430(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(3, rep);
    }

    public ID removeUb23_ConditionCode2430(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(3, rep);
    }

    public ST getCoveredDays7() {
        ST ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST getUb24_CoveredDays7() {
        ST ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST getNonCoveredDays8() {
        ST ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST getUb25_NonCoveredDays8() {
        ST ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CM_UVC[] getValueAmountAndCode3941() {
        CM_UVC[] ret = null;
        try {
            Type[] t = this.getField(6);
            ret = new CM_UVC[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (CM_UVC)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CM_UVC getValueAmountAndCode3941(int rep) {
        CM_UVC ret = null;
        try {
            Type t = this.getField(6, rep);
            ret = (CM_UVC)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CM_UVC getUb26_ValueAmountAndCode3941(int rep) {
        CM_UVC ret = null;
        try {
            Type t = this.getField(6, rep);
            ret = (CM_UVC)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CM_UVC insertValueAmountAndCode3941(int rep) throws HL7Exception {
        return (CM_UVC)super.insertRepetition(6, rep);
    }

    public CM_UVC insertUb26_ValueAmountAndCode3941(int rep) throws HL7Exception {
        return (CM_UVC)super.insertRepetition(6, rep);
    }

    public CM_UVC removeValueAmountAndCode3941(int rep) throws HL7Exception {
        return (CM_UVC)super.removeRepetition(6, rep);
    }

    public CM_UVC removeUb26_ValueAmountAndCode3941(int rep) throws HL7Exception {
        return (CM_UVC)super.removeRepetition(6, rep);
    }

    public CM_OCD[] getOccurrenceCodeAndDate3235() {
        CM_OCD[] ret = null;
        try {
            Type[] t = this.getField(7);
            ret = new CM_OCD[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (CM_OCD)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CM_OCD getOccurrenceCodeAndDate3235(int rep) {
        CM_OCD ret = null;
        try {
            Type t = this.getField(7, rep);
            ret = (CM_OCD)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CM_OCD getUb27_OccurrenceCodeAndDate3235(int rep) {
        CM_OCD ret = null;
        try {
            Type t = this.getField(7, rep);
            ret = (CM_OCD)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CM_OCD insertOccurrenceCodeAndDate3235(int rep) throws HL7Exception {
        return (CM_OCD)super.insertRepetition(7, rep);
    }

    public CM_OCD insertUb27_OccurrenceCodeAndDate3235(int rep) throws HL7Exception {
        return (CM_OCD)super.insertRepetition(7, rep);
    }

    public CM_OCD removeOccurrenceCodeAndDate3235(int rep) throws HL7Exception {
        return (CM_OCD)super.removeRepetition(7, rep);
    }

    public CM_OCD removeUb27_OccurrenceCodeAndDate3235(int rep) throws HL7Exception {
        return (CM_OCD)super.removeRepetition(7, rep);
    }

    public CM_OSP[] getOccurrenceSpanCodeDates() {
        CM_OSP[] ret = null;
        try {
            Type[] t = this.getField(8);
            ret = new CM_OSP[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (CM_OSP)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CM_OSP getOccurrenceSpanCodeDates(int rep) {
        CM_OSP ret = null;
        try {
            Type t = this.getField(8, rep);
            ret = (CM_OSP)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CM_OSP getUb28_OccurrenceSpanCodeDates(int rep) {
        CM_OSP ret = null;
        try {
            Type t = this.getField(8, rep);
            ret = (CM_OSP)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CM_OSP insertOccurrenceSpanCodeDates(int rep) throws HL7Exception {
        return (CM_OSP)super.insertRepetition(8, rep);
    }

    public CM_OSP insertUb28_OccurrenceSpanCodeDates(int rep) throws HL7Exception {
        return (CM_OSP)super.insertRepetition(8, rep);
    }

    public CM_OSP removeOccurrenceSpanCodeDates(int rep) throws HL7Exception {
        return (CM_OSP)super.removeRepetition(8, rep);
    }

    public CM_OSP removeUb28_OccurrenceSpanCodeDates(int rep) throws HL7Exception {
        return (CM_OSP)super.removeRepetition(8, rep);
    }

    public ST[] getUB92Locator2State() {
        ST[] ret = null;
        try {
            Type[] t = this.getField(9);
            ret = new ST[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (ST)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST getUB92Locator2State(int rep) {
        ST ret = null;
        try {
            Type t = this.getField(9, rep);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST getUb29_UB92Locator2State(int rep) {
        ST ret = null;
        try {
            Type t = this.getField(9, rep);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST insertUB92Locator2State(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(9, rep);
    }

    public ST insertUb29_UB92Locator2State(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(9, rep);
    }

    public ST removeUB92Locator2State(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(9, rep);
    }

    public ST removeUb29_UB92Locator2State(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(9, rep);
    }

    public ST[] getUB92Locator11State() {
        ST[] ret = null;
        try {
            Type[] t = this.getField(10);
            ret = new ST[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (ST)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST getUB92Locator11State(int rep) {
        ST ret = null;
        try {
            Type t = this.getField(10, rep);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST getUb210_UB92Locator11State(int rep) {
        ST ret = null;
        try {
            Type t = this.getField(10, rep);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST insertUB92Locator11State(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(10, rep);
    }

    public ST insertUb210_UB92Locator11State(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(10, rep);
    }

    public ST removeUB92Locator11State(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(10, rep);
    }

    public ST removeUb210_UB92Locator11State(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(10, rep);
    }

    public ST getUB92Locator31National() {
        ST ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST getUb211_UB92Locator31National() {
        ST ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST[] getDocumentControlNumber() {
        ST[] ret = null;
        try {
            Type[] t = this.getField(12);
            ret = new ST[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (ST)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST getDocumentControlNumber(int rep) {
        ST ret = null;
        try {
            Type t = this.getField(12, rep);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST getUb212_DocumentControlNumber(int rep) {
        ST ret = null;
        try {
            Type t = this.getField(12, rep);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST insertDocumentControlNumber(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(12, rep);
    }

    public ST insertUb212_DocumentControlNumber(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(12, rep);
    }

    public ST removeDocumentControlNumber(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(12, rep);
    }

    public ST removeUb212_DocumentControlNumber(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(12, rep);
    }

    public ST[] getUB92Locator49National() {
        ST[] ret = null;
        try {
            Type[] t = this.getField(13);
            ret = new ST[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (ST)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST getUB92Locator49National(int rep) {
        ST ret = null;
        try {
            Type t = this.getField(13, rep);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST getUb213_UB92Locator49National(int rep) {
        ST ret = null;
        try {
            Type t = this.getField(13, rep);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST insertUB92Locator49National(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(13, rep);
    }

    public ST insertUb213_UB92Locator49National(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(13, rep);
    }

    public ST removeUB92Locator49National(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(13, rep);
    }

    public ST removeUb213_UB92Locator49National(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(13, rep);
    }

    public ST[] getUB92Locator56State() {
        ST[] ret = null;
        try {
            Type[] t = this.getField(14);
            ret = new ST[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (ST)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST getUB92Locator56State(int rep) {
        ST ret = null;
        try {
            Type t = this.getField(14, rep);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST getUb214_UB92Locator56State(int rep) {
        ST ret = null;
        try {
            Type t = this.getField(14, rep);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST insertUB92Locator56State(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(14, rep);
    }

    public ST insertUb214_UB92Locator56State(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(14, rep);
    }

    public ST removeUB92Locator56State(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(14, rep);
    }

    public ST removeUb214_UB92Locator56State(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(14, rep);
    }

    public ST getUB92Locator57National() {
        ST ret = null;
        try {
            Type t = this.getField(15, 0);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST getUb215_UB92Locator57National() {
        ST ret = null;
        try {
            Type t = this.getField(15, 0);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST[] getUB92Locator78State() {
        ST[] ret = null;
        try {
            Type[] t = this.getField(16);
            ret = new ST[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (ST)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST getUB92Locator78State(int rep) {
        ST ret = null;
        try {
            Type t = this.getField(16, rep);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST getUb216_UB92Locator78State(int rep) {
        ST ret = null;
        try {
            Type t = this.getField(16, rep);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST insertUB92Locator78State(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(16, rep);
    }

    public ST insertUb216_UB92Locator78State(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(16, rep);
    }

    public ST removeUB92Locator78State(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(16, rep);
    }

    public ST removeUb216_UB92Locator78State(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(16, rep);
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new ST(this.getMessage());
            }
            case 2: {
                return new ID(this.getMessage(), new Integer(43));
            }
            case 3: {
                return new ST(this.getMessage());
            }
            case 4: {
                return new ST(this.getMessage());
            }
            case 5: {
                return new CM_UVC(this.getMessage());
            }
            case 6: {
                return new CM_OCD(this.getMessage());
            }
            case 7: {
                return new CM_OSP(this.getMessage());
            }
            case 8: {
                return new ST(this.getMessage());
            }
            case 9: {
                return new ST(this.getMessage());
            }
            case 10: {
                return new ST(this.getMessage());
            }
            case 11: {
                return new ST(this.getMessage());
            }
            case 12: {
                return new ST(this.getMessage());
            }
            case 13: {
                return new ST(this.getMessage());
            }
            case 14: {
                return new ST(this.getMessage());
            }
            case 15: {
                return new ST(this.getMessage());
            }
        }
        return null;
    }
}

