/*
 * Decompiled with CFR 0.152.
 */
package com.aayushatharva.brotli4j.encoder;

import com.aayushatharva.brotli4j.encoder.Encoder;
import com.aayushatharva.brotli4j.encoder.EncoderJNI;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.WritableByteChannel;

public class BrotliEncoderChannel
extends Encoder
implements WritableByteChannel {
    private static final int DEFAULT_BUFFER_SIZE = 16384;
    private final Object mutex = new Object();

    public BrotliEncoderChannel(WritableByteChannel destination, Encoder.Parameters params, int bufferSize) throws IOException {
        super(destination, params, bufferSize);
    }

    public BrotliEncoderChannel(WritableByteChannel destination, Encoder.Parameters params) throws IOException {
        this(destination, params, 16384);
    }

    public BrotliEncoderChannel(WritableByteChannel destination) throws IOException {
        this(destination, new Encoder.Parameters());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isOpen() {
        Object object = this.mutex;
        synchronized (object) {
            return !this.closed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.mutex;
        synchronized (object) {
            super.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(ByteBuffer src) throws IOException {
        Object object = this.mutex;
        synchronized (object) {
            if (this.closed) {
                throw new ClosedChannelException();
            }
            int result = 0;
            while (src.hasRemaining() && this.encode(EncoderJNI.Operation.PROCESS)) {
                int limit = Math.min(src.remaining(), this.inputBuffer.remaining());
                ByteBuffer slice = src.slice();
                ((Buffer)slice).limit(limit);
                this.inputBuffer.put(slice);
                result += limit;
                ((Buffer)src).position(src.position() + limit);
            }
            return result;
        }
    }
}

