/*
 * Decompiled with CFR 0.152.
 */
package com.aayushatharva.brotli4j.encoder;

import com.aayushatharva.brotli4j.encoder.Encoder;
import com.aayushatharva.brotli4j.encoder.EncoderJNI;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.Channels;

public class BrotliOutputStream
extends OutputStream {
    private static final int DEFAULT_BUFFER_SIZE = 16384;
    private final Encoder encoder;

    public BrotliOutputStream(OutputStream destination, Encoder.Parameters params, int bufferSize) throws IOException {
        this.encoder = new Encoder(Channels.newChannel(destination), params, bufferSize);
    }

    public BrotliOutputStream(OutputStream destination, Encoder.Parameters params) throws IOException {
        this(destination, params, 16384);
    }

    public BrotliOutputStream(OutputStream destination) throws IOException {
        this(destination, new Encoder.Parameters());
    }

    @Override
    public void close() throws IOException {
        this.encoder.close();
    }

    @Override
    public void flush() throws IOException {
        if (this.encoder.closed) {
            throw new IOException("write after close");
        }
        this.encoder.flush();
    }

    @Override
    public void write(int b) throws IOException {
        if (this.encoder.closed) {
            throw new IOException("write after close");
        }
        while (!this.encoder.encode(EncoderJNI.Operation.PROCESS)) {
        }
        this.encoder.inputBuffer.put((byte)b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.encoder.closed) {
            throw new IOException("write after close");
        }
        while (len > 0) {
            if (!this.encoder.encode(EncoderJNI.Operation.PROCESS)) continue;
            int limit = Math.min(len, this.encoder.inputBuffer.remaining());
            this.encoder.inputBuffer.put(b, off, limit);
            off += limit;
            len -= limit;
        }
    }
}

