/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.parser;

import com.alibaba.druid.sql.dialect.db2.parser.DB2ExprParser;
import com.alibaba.druid.sql.dialect.db2.parser.DB2StatementParser;
import com.alibaba.druid.sql.dialect.mysql.parser.MySqlExprParser;
import com.alibaba.druid.sql.dialect.mysql.parser.MySqlStatementParser;
import com.alibaba.druid.sql.dialect.odps.parser.OdpsExprParser;
import com.alibaba.druid.sql.dialect.odps.parser.OdpsStatementParser;
import com.alibaba.druid.sql.dialect.oracle.parser.OracleExprParser;
import com.alibaba.druid.sql.dialect.oracle.parser.OracleStatementParser;
import com.alibaba.druid.sql.dialect.phoenix.parser.PhoenixExprParser;
import com.alibaba.druid.sql.dialect.phoenix.parser.PhoenixStatementParser;
import com.alibaba.druid.sql.dialect.postgresql.parser.PGExprParser;
import com.alibaba.druid.sql.dialect.postgresql.parser.PGSQLStatementParser;
import com.alibaba.druid.sql.dialect.sqlserver.parser.SQLServerExprParser;
import com.alibaba.druid.sql.dialect.sqlserver.parser.SQLServerStatementParser;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.SQLStatementParser;

public class SQLParserUtils {
    public static SQLStatementParser createSQLStatementParser(String sql, String dbType) {
        if ("oracle".equals(dbType) || "AliOracle".equals(dbType)) {
            return new OracleStatementParser(sql);
        }
        if ("mysql".equals(dbType)) {
            return new MySqlStatementParser(sql);
        }
        if ("mariadb".equals(dbType)) {
            return new MySqlStatementParser(sql);
        }
        if ("postgresql".equals(dbType)) {
            return new PGSQLStatementParser(sql);
        }
        if ("sqlserver".equals(dbType) || "jtds".equals(dbType)) {
            return new SQLServerStatementParser(sql);
        }
        if ("h2".equals(dbType)) {
            return new MySqlStatementParser(sql);
        }
        if ("db2".equals(dbType)) {
            return new DB2StatementParser(sql);
        }
        if ("odps".equals(dbType)) {
            return new OdpsStatementParser(sql);
        }
        if ("phoenix".equals(dbType)) {
            return new PhoenixStatementParser(sql);
        }
        return new SQLStatementParser(sql);
    }

    public static SQLExprParser createExprParser(String sql, String dbType) {
        if ("oracle".equals(dbType) || "AliOracle".equals(dbType)) {
            return new OracleExprParser(sql);
        }
        if ("mysql".equals(dbType) || "mariadb".equals(dbType) || "h2".equals(dbType)) {
            return new MySqlExprParser(sql);
        }
        if ("postgresql".equals(dbType)) {
            return new PGExprParser(sql);
        }
        if ("sqlserver".equals(dbType) || "jtds".equals(dbType)) {
            return new SQLServerExprParser(sql);
        }
        if ("db2".equals(dbType)) {
            return new DB2ExprParser(sql);
        }
        if ("odps".equals(dbType)) {
            return new OdpsExprParser(sql);
        }
        if ("phoenix".equals(dbType)) {
            return new PhoenixExprParser(sql);
        }
        return new SQLExprParser(sql);
    }
}

