/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.route53.model.Change;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeBatch
implements Serializable {
    private String comment;
    private ListWithAutoConstructFlag<Change> changes;

    public ChangeBatch() {
    }

    public ChangeBatch(List<Change> changes) {
        this.setChanges(changes);
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public ChangeBatch withComment(String comment) {
        this.comment = comment;
        return this;
    }

    public List<Change> getChanges() {
        if (this.changes == null) {
            this.changes = new ListWithAutoConstructFlag();
            this.changes.setAutoConstruct(true);
        }
        return this.changes;
    }

    public void setChanges(Collection<Change> changes) {
        if (changes == null) {
            this.changes = null;
            return;
        }
        ListWithAutoConstructFlag changesCopy = new ListWithAutoConstructFlag(changes.size());
        changesCopy.addAll(changes);
        this.changes = changesCopy;
    }

    public ChangeBatch withChanges(Change ... changes) {
        if (this.getChanges() == null) {
            this.setChanges(new ArrayList<Change>(changes.length));
        }
        for (Change value : changes) {
            this.getChanges().add(value);
        }
        return this;
    }

    public ChangeBatch withChanges(Collection<Change> changes) {
        if (changes == null) {
            this.changes = null;
        } else {
            ListWithAutoConstructFlag changesCopy = new ListWithAutoConstructFlag(changes.size());
            changesCopy.addAll(changes);
            this.changes = changesCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getComment() != null) {
            sb.append("Comment: " + this.getComment() + ",");
        }
        if (this.getChanges() != null) {
            sb.append("Changes: " + this.getChanges());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getComment() == null ? 0 : this.getComment().hashCode());
        hashCode = 31 * hashCode + (this.getChanges() == null ? 0 : this.getChanges().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChangeBatch)) {
            return false;
        }
        ChangeBatch other = (ChangeBatch)obj;
        if (other.getComment() == null ^ this.getComment() == null) {
            return false;
        }
        if (other.getComment() != null && !other.getComment().equals(this.getComment())) {
            return false;
        }
        if (other.getChanges() == null ^ this.getChanges() == null) {
            return false;
        }
        return other.getChanges() == null || other.getChanges().equals(this.getChanges());
    }
}

