/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sqs;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.DefaultErrorResponseHandler;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.StaxResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.model.AddPermissionRequest;
import com.amazonaws.services.sqs.model.ChangeMessageVisibilityBatchRequest;
import com.amazonaws.services.sqs.model.ChangeMessageVisibilityBatchRequestEntry;
import com.amazonaws.services.sqs.model.ChangeMessageVisibilityBatchResult;
import com.amazonaws.services.sqs.model.ChangeMessageVisibilityRequest;
import com.amazonaws.services.sqs.model.CreateQueueRequest;
import com.amazonaws.services.sqs.model.CreateQueueResult;
import com.amazonaws.services.sqs.model.DeleteMessageBatchRequest;
import com.amazonaws.services.sqs.model.DeleteMessageBatchRequestEntry;
import com.amazonaws.services.sqs.model.DeleteMessageBatchResult;
import com.amazonaws.services.sqs.model.DeleteMessageRequest;
import com.amazonaws.services.sqs.model.DeleteQueueRequest;
import com.amazonaws.services.sqs.model.GetQueueAttributesRequest;
import com.amazonaws.services.sqs.model.GetQueueAttributesResult;
import com.amazonaws.services.sqs.model.GetQueueUrlRequest;
import com.amazonaws.services.sqs.model.GetQueueUrlResult;
import com.amazonaws.services.sqs.model.ListDeadLetterSourceQueuesRequest;
import com.amazonaws.services.sqs.model.ListDeadLetterSourceQueuesResult;
import com.amazonaws.services.sqs.model.ListQueuesRequest;
import com.amazonaws.services.sqs.model.ListQueuesResult;
import com.amazonaws.services.sqs.model.ReceiveMessageRequest;
import com.amazonaws.services.sqs.model.ReceiveMessageResult;
import com.amazonaws.services.sqs.model.RemovePermissionRequest;
import com.amazonaws.services.sqs.model.SendMessageBatchRequest;
import com.amazonaws.services.sqs.model.SendMessageBatchRequestEntry;
import com.amazonaws.services.sqs.model.SendMessageBatchResult;
import com.amazonaws.services.sqs.model.SendMessageRequest;
import com.amazonaws.services.sqs.model.SendMessageResult;
import com.amazonaws.services.sqs.model.SetQueueAttributesRequest;
import com.amazonaws.services.sqs.model.transform.AddPermissionRequestMarshaller;
import com.amazonaws.services.sqs.model.transform.BatchEntryIdsNotDistinctExceptionUnmarshaller;
import com.amazonaws.services.sqs.model.transform.BatchRequestTooLongExceptionUnmarshaller;
import com.amazonaws.services.sqs.model.transform.ChangeMessageVisibilityBatchRequestMarshaller;
import com.amazonaws.services.sqs.model.transform.ChangeMessageVisibilityBatchResultStaxUnmarshaller;
import com.amazonaws.services.sqs.model.transform.ChangeMessageVisibilityRequestMarshaller;
import com.amazonaws.services.sqs.model.transform.CreateQueueRequestMarshaller;
import com.amazonaws.services.sqs.model.transform.CreateQueueResultStaxUnmarshaller;
import com.amazonaws.services.sqs.model.transform.DeleteMessageBatchRequestMarshaller;
import com.amazonaws.services.sqs.model.transform.DeleteMessageBatchResultStaxUnmarshaller;
import com.amazonaws.services.sqs.model.transform.DeleteMessageRequestMarshaller;
import com.amazonaws.services.sqs.model.transform.DeleteQueueRequestMarshaller;
import com.amazonaws.services.sqs.model.transform.EmptyBatchRequestExceptionUnmarshaller;
import com.amazonaws.services.sqs.model.transform.GetQueueAttributesRequestMarshaller;
import com.amazonaws.services.sqs.model.transform.GetQueueAttributesResultStaxUnmarshaller;
import com.amazonaws.services.sqs.model.transform.GetQueueUrlRequestMarshaller;
import com.amazonaws.services.sqs.model.transform.GetQueueUrlResultStaxUnmarshaller;
import com.amazonaws.services.sqs.model.transform.InvalidAttributeNameExceptionUnmarshaller;
import com.amazonaws.services.sqs.model.transform.InvalidBatchEntryIdExceptionUnmarshaller;
import com.amazonaws.services.sqs.model.transform.InvalidIdFormatExceptionUnmarshaller;
import com.amazonaws.services.sqs.model.transform.InvalidMessageContentsExceptionUnmarshaller;
import com.amazonaws.services.sqs.model.transform.ListDeadLetterSourceQueuesRequestMarshaller;
import com.amazonaws.services.sqs.model.transform.ListDeadLetterSourceQueuesResultStaxUnmarshaller;
import com.amazonaws.services.sqs.model.transform.ListQueuesRequestMarshaller;
import com.amazonaws.services.sqs.model.transform.ListQueuesResultStaxUnmarshaller;
import com.amazonaws.services.sqs.model.transform.MessageNotInflightExceptionUnmarshaller;
import com.amazonaws.services.sqs.model.transform.OverLimitExceptionUnmarshaller;
import com.amazonaws.services.sqs.model.transform.QueueDeletedRecentlyExceptionUnmarshaller;
import com.amazonaws.services.sqs.model.transform.QueueDoesNotExistExceptionUnmarshaller;
import com.amazonaws.services.sqs.model.transform.QueueNameExistsExceptionUnmarshaller;
import com.amazonaws.services.sqs.model.transform.ReceiptHandleIsInvalidExceptionUnmarshaller;
import com.amazonaws.services.sqs.model.transform.ReceiveMessageRequestMarshaller;
import com.amazonaws.services.sqs.model.transform.ReceiveMessageResultStaxUnmarshaller;
import com.amazonaws.services.sqs.model.transform.RemovePermissionRequestMarshaller;
import com.amazonaws.services.sqs.model.transform.SendMessageBatchRequestMarshaller;
import com.amazonaws.services.sqs.model.transform.SendMessageBatchResultStaxUnmarshaller;
import com.amazonaws.services.sqs.model.transform.SendMessageRequestMarshaller;
import com.amazonaws.services.sqs.model.transform.SendMessageResultStaxUnmarshaller;
import com.amazonaws.services.sqs.model.transform.SetQueueAttributesRequestMarshaller;
import com.amazonaws.services.sqs.model.transform.TooManyEntriesInBatchRequestExceptionUnmarshaller;
import com.amazonaws.transform.StandardErrorUnmarshaller;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmazonSQSClient
extends AmazonWebServiceClient
implements AmazonSQS {
    private AWSCredentialsProvider awsCredentialsProvider;
    protected final List<Unmarshaller<AmazonServiceException, Node>> exceptionUnmarshallers = new ArrayList<Unmarshaller<AmazonServiceException, Node>>();

    public AmazonSQSClient() {
        this(new DefaultAWSCredentialsProviderChain(), new ClientConfiguration());
    }

    public AmazonSQSClient(ClientConfiguration clientConfiguration) {
        this(new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public AmazonSQSClient(AWSCredentials awsCredentials) {
        this(awsCredentials, new ClientConfiguration());
    }

    public AmazonSQSClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AmazonSQSClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, new ClientConfiguration());
    }

    public AmazonSQSClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    public AmazonSQSClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(clientConfiguration, requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    private void init() {
        this.exceptionUnmarshallers.add(new QueueDeletedRecentlyExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new QueueNameExistsExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new EmptyBatchRequestExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidMessageContentsExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidBatchEntryIdExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new OverLimitExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new TooManyEntriesInBatchRequestExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidIdFormatExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new QueueDoesNotExistExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidAttributeNameExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new BatchRequestTooLongExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new ReceiptHandleIsInvalidExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new MessageNotInflightExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new BatchEntryIdsNotDistinctExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new StandardErrorUnmarshaller());
        this.setEndpoint("sqs.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/sqs/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/sqs/request.handler2s"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setQueueAttributes(SetQueueAttributesRequest setQueueAttributesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(setQueueAttributesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<SetQueueAttributesRequest> request = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new SetQueueAttributesRequestMarshaller().marshall(setQueueAttributesRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            this.invoke(request, null, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChangeMessageVisibilityBatchResult changeMessageVisibilityBatch(ChangeMessageVisibilityBatchRequest changeMessageVisibilityBatchRequest) {
        ExecutionContext executionContext = this.createExecutionContext(changeMessageVisibilityBatchRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<ChangeMessageVisibilityBatchRequest> request = null;
        Response<ChangeMessageVisibilityBatchResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new ChangeMessageVisibilityBatchRequestMarshaller().marshall(changeMessageVisibilityBatchRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new ChangeMessageVisibilityBatchResultStaxUnmarshaller(), executionContext);
            ChangeMessageVisibilityBatchResult changeMessageVisibilityBatchResult = response.getAwsResponse();
            return changeMessageVisibilityBatchResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changeMessageVisibility(ChangeMessageVisibilityRequest changeMessageVisibilityRequest) {
        ExecutionContext executionContext = this.createExecutionContext(changeMessageVisibilityRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<ChangeMessageVisibilityRequest> request = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new ChangeMessageVisibilityRequestMarshaller().marshall(changeMessageVisibilityRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            this.invoke(request, null, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetQueueUrlResult getQueueUrl(GetQueueUrlRequest getQueueUrlRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getQueueUrlRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<GetQueueUrlRequest> request = null;
        Response<GetQueueUrlResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new GetQueueUrlRequestMarshaller().marshall(getQueueUrlRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new GetQueueUrlResultStaxUnmarshaller(), executionContext);
            GetQueueUrlResult getQueueUrlResult = response.getAwsResponse();
            return getQueueUrlResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePermission(RemovePermissionRequest removePermissionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(removePermissionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<RemovePermissionRequest> request = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new RemovePermissionRequestMarshaller().marshall(removePermissionRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            this.invoke(request, null, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetQueueAttributesResult getQueueAttributes(GetQueueAttributesRequest getQueueAttributesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getQueueAttributesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<GetQueueAttributesRequest> request = null;
        Response<GetQueueAttributesResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new GetQueueAttributesRequestMarshaller().marshall(getQueueAttributesRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new GetQueueAttributesResultStaxUnmarshaller(), executionContext);
            GetQueueAttributesResult getQueueAttributesResult = response.getAwsResponse();
            return getQueueAttributesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SendMessageBatchResult sendMessageBatch(SendMessageBatchRequest sendMessageBatchRequest) {
        ExecutionContext executionContext = this.createExecutionContext(sendMessageBatchRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<SendMessageBatchRequest> request = null;
        Response<SendMessageBatchResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new SendMessageBatchRequestMarshaller().marshall(sendMessageBatchRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new SendMessageBatchResultStaxUnmarshaller(), executionContext);
            SendMessageBatchResult sendMessageBatchResult = response.getAwsResponse();
            return sendMessageBatchResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDeadLetterSourceQueuesResult listDeadLetterSourceQueues(ListDeadLetterSourceQueuesRequest listDeadLetterSourceQueuesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listDeadLetterSourceQueuesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<ListDeadLetterSourceQueuesRequest> request = null;
        Response<ListDeadLetterSourceQueuesResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new ListDeadLetterSourceQueuesRequestMarshaller().marshall(listDeadLetterSourceQueuesRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new ListDeadLetterSourceQueuesResultStaxUnmarshaller(), executionContext);
            ListDeadLetterSourceQueuesResult listDeadLetterSourceQueuesResult = response.getAwsResponse();
            return listDeadLetterSourceQueuesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteQueue(DeleteQueueRequest deleteQueueRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteQueueRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DeleteQueueRequest> request = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DeleteQueueRequestMarshaller().marshall(deleteQueueRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            this.invoke(request, null, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SendMessageResult sendMessage(SendMessageRequest sendMessageRequest) {
        ExecutionContext executionContext = this.createExecutionContext(sendMessageRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<SendMessageRequest> request = null;
        Response<SendMessageResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new SendMessageRequestMarshaller().marshall(sendMessageRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new SendMessageResultStaxUnmarshaller(), executionContext);
            SendMessageResult sendMessageResult = response.getAwsResponse();
            return sendMessageResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReceiveMessageResult receiveMessage(ReceiveMessageRequest receiveMessageRequest) {
        ExecutionContext executionContext = this.createExecutionContext(receiveMessageRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<ReceiveMessageRequest> request = null;
        Response<ReceiveMessageResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new ReceiveMessageRequestMarshaller().marshall(receiveMessageRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new ReceiveMessageResultStaxUnmarshaller(), executionContext);
            ReceiveMessageResult receiveMessageResult = response.getAwsResponse();
            return receiveMessageResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListQueuesResult listQueues(ListQueuesRequest listQueuesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listQueuesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<ListQueuesRequest> request = null;
        Response<ListQueuesResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new ListQueuesRequestMarshaller().marshall(listQueuesRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new ListQueuesResultStaxUnmarshaller(), executionContext);
            ListQueuesResult listQueuesResult = response.getAwsResponse();
            return listQueuesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteMessageBatchResult deleteMessageBatch(DeleteMessageBatchRequest deleteMessageBatchRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteMessageBatchRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DeleteMessageBatchRequest> request = null;
        Response<DeleteMessageBatchResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DeleteMessageBatchRequestMarshaller().marshall(deleteMessageBatchRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new DeleteMessageBatchResultStaxUnmarshaller(), executionContext);
            DeleteMessageBatchResult deleteMessageBatchResult = response.getAwsResponse();
            return deleteMessageBatchResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateQueueResult createQueue(CreateQueueRequest createQueueRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createQueueRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<CreateQueueRequest> request = null;
        Response<CreateQueueResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new CreateQueueRequestMarshaller().marshall(createQueueRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new CreateQueueResultStaxUnmarshaller(), executionContext);
            CreateQueueResult createQueueResult = response.getAwsResponse();
            return createQueueResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPermission(AddPermissionRequest addPermissionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(addPermissionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<AddPermissionRequest> request = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new AddPermissionRequestMarshaller().marshall(addPermissionRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            this.invoke(request, null, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteMessage(DeleteMessageRequest deleteMessageRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteMessageRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DeleteMessageRequest> request = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DeleteMessageRequestMarshaller().marshall(deleteMessageRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            this.invoke(request, null, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null);
        }
    }

    @Override
    public ListQueuesResult listQueues() throws AmazonServiceException, AmazonClientException {
        return this.listQueues(new ListQueuesRequest());
    }

    @Override
    public void setQueueAttributes(String queueUrl, Map<String, String> attributes) {
        SetQueueAttributesRequest setQueueAttributesRequest = new SetQueueAttributesRequest();
        setQueueAttributesRequest.setQueueUrl(queueUrl);
        setQueueAttributesRequest.setAttributes(attributes);
        this.setQueueAttributes(setQueueAttributesRequest);
    }

    @Override
    public ChangeMessageVisibilityBatchResult changeMessageVisibilityBatch(String queueUrl, List<ChangeMessageVisibilityBatchRequestEntry> entries) {
        ChangeMessageVisibilityBatchRequest changeMessageVisibilityBatchRequest = new ChangeMessageVisibilityBatchRequest();
        changeMessageVisibilityBatchRequest.setQueueUrl(queueUrl);
        changeMessageVisibilityBatchRequest.setEntries(entries);
        return this.changeMessageVisibilityBatch(changeMessageVisibilityBatchRequest);
    }

    @Override
    public void changeMessageVisibility(String queueUrl, String receiptHandle, Integer visibilityTimeout) {
        ChangeMessageVisibilityRequest changeMessageVisibilityRequest = new ChangeMessageVisibilityRequest();
        changeMessageVisibilityRequest.setQueueUrl(queueUrl);
        changeMessageVisibilityRequest.setReceiptHandle(receiptHandle);
        changeMessageVisibilityRequest.setVisibilityTimeout(visibilityTimeout);
        this.changeMessageVisibility(changeMessageVisibilityRequest);
    }

    @Override
    public GetQueueUrlResult getQueueUrl(String queueName) {
        GetQueueUrlRequest getQueueUrlRequest = new GetQueueUrlRequest();
        getQueueUrlRequest.setQueueName(queueName);
        return this.getQueueUrl(getQueueUrlRequest);
    }

    @Override
    public void removePermission(String queueUrl, String label) {
        RemovePermissionRequest removePermissionRequest = new RemovePermissionRequest();
        removePermissionRequest.setQueueUrl(queueUrl);
        removePermissionRequest.setLabel(label);
        this.removePermission(removePermissionRequest);
    }

    @Override
    public GetQueueAttributesResult getQueueAttributes(String queueUrl, List<String> attributeNames) {
        GetQueueAttributesRequest getQueueAttributesRequest = new GetQueueAttributesRequest();
        getQueueAttributesRequest.setQueueUrl(queueUrl);
        getQueueAttributesRequest.setAttributeNames(attributeNames);
        return this.getQueueAttributes(getQueueAttributesRequest);
    }

    @Override
    public SendMessageBatchResult sendMessageBatch(String queueUrl, List<SendMessageBatchRequestEntry> entries) {
        SendMessageBatchRequest sendMessageBatchRequest = new SendMessageBatchRequest();
        sendMessageBatchRequest.setQueueUrl(queueUrl);
        sendMessageBatchRequest.setEntries(entries);
        return this.sendMessageBatch(sendMessageBatchRequest);
    }

    @Override
    public void deleteQueue(String queueUrl) {
        DeleteQueueRequest deleteQueueRequest = new DeleteQueueRequest();
        deleteQueueRequest.setQueueUrl(queueUrl);
        this.deleteQueue(deleteQueueRequest);
    }

    @Override
    public SendMessageResult sendMessage(String queueUrl, String messageBody) {
        SendMessageRequest sendMessageRequest = new SendMessageRequest();
        sendMessageRequest.setQueueUrl(queueUrl);
        sendMessageRequest.setMessageBody(messageBody);
        return this.sendMessage(sendMessageRequest);
    }

    @Override
    public ReceiveMessageResult receiveMessage(String queueUrl) {
        ReceiveMessageRequest receiveMessageRequest = new ReceiveMessageRequest();
        receiveMessageRequest.setQueueUrl(queueUrl);
        return this.receiveMessage(receiveMessageRequest);
    }

    @Override
    public ListQueuesResult listQueues(String queueNamePrefix) {
        ListQueuesRequest listQueuesRequest = new ListQueuesRequest();
        listQueuesRequest.setQueueNamePrefix(queueNamePrefix);
        return this.listQueues(listQueuesRequest);
    }

    @Override
    public DeleteMessageBatchResult deleteMessageBatch(String queueUrl, List<DeleteMessageBatchRequestEntry> entries) {
        DeleteMessageBatchRequest deleteMessageBatchRequest = new DeleteMessageBatchRequest();
        deleteMessageBatchRequest.setQueueUrl(queueUrl);
        deleteMessageBatchRequest.setEntries(entries);
        return this.deleteMessageBatch(deleteMessageBatchRequest);
    }

    @Override
    public CreateQueueResult createQueue(String queueName) {
        CreateQueueRequest createQueueRequest = new CreateQueueRequest();
        createQueueRequest.setQueueName(queueName);
        return this.createQueue(createQueueRequest);
    }

    @Override
    public void addPermission(String queueUrl, String label, List<String> aWSAccountIds, List<String> actions) {
        AddPermissionRequest addPermissionRequest = new AddPermissionRequest();
        addPermissionRequest.setQueueUrl(queueUrl);
        addPermissionRequest.setLabel(label);
        addPermissionRequest.setAWSAccountIds(aWSAccountIds);
        addPermissionRequest.setActions(actions);
        this.addPermission(addPermissionRequest);
    }

    @Override
    public void deleteMessage(String queueUrl, String receiptHandle) {
        DeleteMessageRequest deleteMessageRequest = new DeleteMessageRequest();
        deleteMessageRequest.setQueueUrl(queueUrl);
        deleteMessageRequest.setReceiptHandle(receiptHandle);
        this.deleteMessage(deleteMessageRequest);
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, Unmarshaller<X, StaxUnmarshallerContext> unmarshaller, ExecutionContext executionContext) {
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        for (Map.Entry<String, String> entry : originalRequest.copyPrivateRequestParameters().entrySet()) {
            request.addParameter(entry.getKey(), entry.getValue());
        }
        AWSCredentials credentials = this.awsCredentialsProvider.getCredentials();
        if (originalRequest.getRequestCredentials() != null) {
            credentials = originalRequest.getRequestCredentials();
        }
        executionContext.setCredentials(credentials);
        StaxResponseHandler<X> responseHandler = new StaxResponseHandler<X>(unmarshaller);
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }
}

