/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codepipeline.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.codepipeline.model.ActionExecution;
import com.amazonaws.services.codepipeline.model.transform.ErrorDetailsJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class ActionExecutionJsonMarshaller {
    private static ActionExecutionJsonMarshaller instance;

    public void marshall(ActionExecution actionExecution, JSONWriter jsonWriter) {
        if (actionExecution == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (actionExecution.getStatus() != null) {
                jsonWriter.key("status").value((Object)actionExecution.getStatus());
            }
            if (actionExecution.getSummary() != null) {
                jsonWriter.key("summary").value((Object)actionExecution.getSummary());
            }
            if (actionExecution.getLastStatusChange() != null) {
                jsonWriter.key("lastStatusChange").value(actionExecution.getLastStatusChange());
            }
            if (actionExecution.getExternalExecutionId() != null) {
                jsonWriter.key("externalExecutionId").value((Object)actionExecution.getExternalExecutionId());
            }
            if (actionExecution.getExternalExecutionUrl() != null) {
                jsonWriter.key("externalExecutionUrl").value((Object)actionExecution.getExternalExecutionUrl());
            }
            if (actionExecution.getPercentComplete() != null) {
                jsonWriter.key("percentComplete").value((Object)actionExecution.getPercentComplete());
            }
            if (actionExecution.getErrorDetails() != null) {
                jsonWriter.key("errorDetails");
                ErrorDetailsJsonMarshaller.getInstance().marshall(actionExecution.getErrorDetails(), jsonWriter);
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ActionExecutionJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ActionExecutionJsonMarshaller();
        }
        return instance;
    }
}

