/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.Condition;
import com.amazonaws.services.dynamodbv2.model.transform.AttributeValueJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;
import java.util.List;

public class ConditionJsonMarshaller {
    private static ConditionJsonMarshaller instance;

    public void marshall(Condition condition, JSONWriter jsonWriter) {
        if (condition == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            List<AttributeValue> attributeValueListList = condition.getAttributeValueList();
            if (attributeValueListList != null) {
                jsonWriter.key("AttributeValueList");
                jsonWriter.array();
                for (AttributeValue attributeValueListListValue : attributeValueListList) {
                    if (attributeValueListListValue == null) continue;
                    AttributeValueJsonMarshaller.getInstance().marshall(attributeValueListListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (condition.getComparisonOperator() != null) {
                jsonWriter.key("ComparisonOperator").value((Object)condition.getComparisonOperator());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ConditionJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ConditionJsonMarshaller();
        }
        return instance;
    }
}

