/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.rds.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CopyDBClusterSnapshotRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String sourceDBClusterSnapshotIdentifier;
    private String targetDBClusterSnapshotIdentifier;
    private ListWithAutoConstructFlag<Tag> tags;

    public String getSourceDBClusterSnapshotIdentifier() {
        return this.sourceDBClusterSnapshotIdentifier;
    }

    public void setSourceDBClusterSnapshotIdentifier(String sourceDBClusterSnapshotIdentifier) {
        this.sourceDBClusterSnapshotIdentifier = sourceDBClusterSnapshotIdentifier;
    }

    public CopyDBClusterSnapshotRequest withSourceDBClusterSnapshotIdentifier(String sourceDBClusterSnapshotIdentifier) {
        this.sourceDBClusterSnapshotIdentifier = sourceDBClusterSnapshotIdentifier;
        return this;
    }

    public String getTargetDBClusterSnapshotIdentifier() {
        return this.targetDBClusterSnapshotIdentifier;
    }

    public void setTargetDBClusterSnapshotIdentifier(String targetDBClusterSnapshotIdentifier) {
        this.targetDBClusterSnapshotIdentifier = targetDBClusterSnapshotIdentifier;
    }

    public CopyDBClusterSnapshotRequest withTargetDBClusterSnapshotIdentifier(String targetDBClusterSnapshotIdentifier) {
        this.targetDBClusterSnapshotIdentifier = targetDBClusterSnapshotIdentifier;
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new ListWithAutoConstructFlag();
            this.tags.setAutoConstruct(true);
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        ListWithAutoConstructFlag tagsCopy = new ListWithAutoConstructFlag(tags.size());
        tagsCopy.addAll(tags);
        this.tags = tagsCopy;
    }

    public CopyDBClusterSnapshotRequest withTags(Tag ... tags) {
        if (this.getTags() == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag value : tags) {
            this.getTags().add(value);
        }
        return this;
    }

    public CopyDBClusterSnapshotRequest withTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
        } else {
            ListWithAutoConstructFlag tagsCopy = new ListWithAutoConstructFlag(tags.size());
            tagsCopy.addAll(tags);
            this.tags = tagsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSourceDBClusterSnapshotIdentifier() != null) {
            sb.append("SourceDBClusterSnapshotIdentifier: " + this.getSourceDBClusterSnapshotIdentifier() + ",");
        }
        if (this.getTargetDBClusterSnapshotIdentifier() != null) {
            sb.append("TargetDBClusterSnapshotIdentifier: " + this.getTargetDBClusterSnapshotIdentifier() + ",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: " + this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSourceDBClusterSnapshotIdentifier() == null ? 0 : this.getSourceDBClusterSnapshotIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getTargetDBClusterSnapshotIdentifier() == null ? 0 : this.getTargetDBClusterSnapshotIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopyDBClusterSnapshotRequest)) {
            return false;
        }
        CopyDBClusterSnapshotRequest other = (CopyDBClusterSnapshotRequest)obj;
        if (other.getSourceDBClusterSnapshotIdentifier() == null ^ this.getSourceDBClusterSnapshotIdentifier() == null) {
            return false;
        }
        if (other.getSourceDBClusterSnapshotIdentifier() != null && !other.getSourceDBClusterSnapshotIdentifier().equals(this.getSourceDBClusterSnapshotIdentifier())) {
            return false;
        }
        if (other.getTargetDBClusterSnapshotIdentifier() == null ^ this.getTargetDBClusterSnapshotIdentifier() == null) {
            return false;
        }
        if (other.getTargetDBClusterSnapshotIdentifier() != null && !other.getTargetDBClusterSnapshotIdentifier().equals(this.getTargetDBClusterSnapshotIdentifier())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public CopyDBClusterSnapshotRequest clone() {
        return (CopyDBClusterSnapshotRequest)super.clone();
    }
}

