/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.runtime.events.models.s3;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.List;
import org.joda.time.DateTime;

public class S3EventNotification {
    private final List<S3EventNotificationRecord> records;

    public S3EventNotification(List<S3EventNotificationRecord> records) {
        this.records = records;
    }

    public List<S3EventNotificationRecord> getRecords() {
        return this.records;
    }

    public static class S3EventNotificationRecord {
        private final String awsRegion;
        private final String eventName;
        private final String eventSource;
        private DateTime eventTime;
        private final String eventVersion;
        private final RequestParametersEntity requestParameters;
        private final ResponseElementsEntity responseElements;
        private final S3Entity s3;
        private final UserIdentityEntity userIdentity;

        public S3EventNotificationRecord(String awsRegion, String eventName, String eventSource, String eventTime, String eventVersion, RequestParametersEntity requestParameters, ResponseElementsEntity responseElements, S3Entity s3, UserIdentityEntity userIdentity) {
            this.awsRegion = awsRegion;
            this.eventName = eventName;
            this.eventSource = eventSource;
            if (eventTime != null) {
                this.eventTime = DateTime.parse((String)eventTime);
            }
            this.eventVersion = eventVersion;
            this.requestParameters = requestParameters;
            this.responseElements = responseElements;
            this.s3 = s3;
            this.userIdentity = userIdentity;
        }

        public String getAwsRegion() {
            return this.awsRegion;
        }

        public String getEventName() {
            return this.eventName;
        }

        public String getEventSource() {
            return this.eventSource;
        }

        public DateTime getEventTime() {
            return this.eventTime;
        }

        public String getEventVersion() {
            return this.eventVersion;
        }

        public RequestParametersEntity getRequestParameters() {
            return this.requestParameters;
        }

        public ResponseElementsEntity getResponseElements() {
            return this.responseElements;
        }

        public S3Entity getS3() {
            return this.s3;
        }

        public UserIdentityEntity getUserIdentity() {
            return this.userIdentity;
        }
    }

    public static class ResponseElementsEntity {
        private final String xAmzId2;
        private final String xAmzRequestId;

        public ResponseElementsEntity(String xAmzId2, String xAmzRequestId) {
            this.xAmzId2 = xAmzId2;
            this.xAmzRequestId = xAmzRequestId;
        }

        public String getxAmzId2() {
            return this.xAmzId2;
        }

        public String getxAmzRequestId() {
            return this.xAmzRequestId;
        }
    }

    public static class RequestParametersEntity {
        private final String sourceIPAddress;

        public RequestParametersEntity(String sourceIPAddress) {
            this.sourceIPAddress = sourceIPAddress;
        }

        public String getSourceIPAddress() {
            return this.sourceIPAddress;
        }
    }

    public static class S3Entity {
        private final String configurationId;
        private final S3BucketEntity bucket;
        private final S3ObjectEntity object;
        private final String s3SchemaVersion;

        public S3Entity(String configurationId, S3BucketEntity bucket, S3ObjectEntity object, String s3SchemaVersion) {
            this.configurationId = configurationId;
            this.bucket = bucket;
            this.object = object;
            this.s3SchemaVersion = s3SchemaVersion;
        }

        public String getConfigurationId() {
            return this.configurationId;
        }

        public S3BucketEntity getBucket() {
            return this.bucket;
        }

        public S3ObjectEntity getObject() {
            return this.object;
        }

        public String getS3SchemaVersion() {
            return this.s3SchemaVersion;
        }
    }

    public static class S3ObjectEntity {
        private final String key;
        private final Long size;
        private final String eTag;
        private final String versionId;
        private final String sequencer;
        private static final String DEFAULT_ENCODING = "UTF-8";

        @Deprecated
        public S3ObjectEntity(String key, Integer size, String eTag, String versionId) {
            this.key = key;
            this.size = size == null ? null : Long.valueOf(size.longValue());
            this.eTag = eTag;
            this.versionId = versionId;
            this.sequencer = null;
        }

        @Deprecated
        public S3ObjectEntity(String key, Long size, String eTag, String versionId) {
            this(key, size, eTag, versionId, null);
        }

        public S3ObjectEntity(String key, Long size, String eTag, String versionId, String sequencer) {
            this.key = key;
            this.size = size;
            this.eTag = eTag;
            this.versionId = versionId;
            this.sequencer = sequencer;
        }

        public String getKey() {
            return this.key;
        }

        public String getUrlDecodedKey() {
            return S3ObjectEntity.urlDecode(this.getKey());
        }

        private static String urlDecode(String value) {
            if (value == null) {
                return null;
            }
            try {
                return URLDecoder.decode(value, DEFAULT_ENCODING);
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException(ex);
            }
        }

        @Deprecated
        public Integer getSize() {
            return this.size == null ? null : Integer.valueOf(this.size.intValue());
        }

        public Long getSizeAsLong() {
            return this.size;
        }

        public String geteTag() {
            return this.eTag;
        }

        public String getVersionId() {
            return this.versionId;
        }

        public String getSequencer() {
            return this.sequencer;
        }
    }

    public static class S3BucketEntity {
        private final String name;
        private final UserIdentityEntity ownerIdentity;
        private final String arn;

        public S3BucketEntity(String name, UserIdentityEntity ownerIdentity, String arn) {
            this.name = name;
            this.ownerIdentity = ownerIdentity;
            this.arn = arn;
        }

        public String getName() {
            return this.name;
        }

        public UserIdentityEntity getOwnerIdentity() {
            return this.ownerIdentity;
        }

        public String getArn() {
            return this.arn;
        }
    }

    public static class UserIdentityEntity {
        private final String principalId;

        public UserIdentityEntity(String principalId) {
            this.principalId = principalId;
        }

        public String getPrincipalId() {
            return this.principalId;
        }
    }
}

