/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.bos.model;

import com.baidubce.util.Base64Utils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.HashMap;
import java.util.Map;

@JsonPropertyOrder(value={"outputHeader", "csv", "json"})
public class OutputSerialization {
    private boolean outputHeader = false;
    @JsonIgnore
    private Map<String, String> params = new HashMap<String, String>();
    @JsonProperty(value="csv")
    private Map<String, String> csvParams;
    @JsonProperty(value="json")
    private Map<String, String> jsonParams;

    public void setOutputHeader(boolean outputHeader) {
        this.outputHeader = outputHeader;
    }

    public boolean getOutputHeader() {
        return this.outputHeader;
    }

    public OutputSerialization withOutputHeader(boolean outputHeader) {
        this.setOutputHeader(outputHeader);
        return this;
    }

    public OutputSerialization withQuoteFields(String quoteFields) {
        this.params.put("quoteFields", quoteFields);
        return this;
    }

    public OutputSerialization withRecordDelimiter(String recordDelimiter) {
        this.params.put("recordDelimiter", Base64Utils.encode(recordDelimiter));
        return this;
    }

    public OutputSerialization withFieldDelimiter(String fieldDelimiter) {
        this.params.put("fieldDelimiter", Base64Utils.encode(fieldDelimiter));
        return this;
    }

    public OutputSerialization withQuoteCharacter(String quoteCharacter) {
        this.params.put("quoteCharacter", Base64Utils.encode(quoteCharacter));
        return this;
    }

    public Map<String, String> getCsvParams() {
        return this.csvParams;
    }

    public void setCsvParams(Map<String, String> csvParams) {
        this.csvParams = csvParams;
    }

    public Map<String, String> getJsonParams() {
        return this.jsonParams;
    }

    public void setJsonParams(Map<String, String> jsonParams) {
        this.jsonParams = jsonParams;
    }

    public String getValue(String key) {
        return this.params.get(key);
    }

    public Map<String, String> getParams() {
        return this.params;
    }
}

