/*
 * Decompiled with CFR 0.152.
 */
package com.dyuproject.protostuff;

import com.dyuproject.protostuff.ByteString;
import com.dyuproject.protostuff.Input;
import com.dyuproject.protostuff.Output;
import com.dyuproject.protostuff.ProtobufException;
import com.dyuproject.protostuff.Schema;
import com.dyuproject.protostuff.StringSerializer;
import com.dyuproject.protostuff.UninitializedMessageException;
import com.dyuproject.protostuff.WireFormat;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ByteArrayInput
implements Input {
    private final byte[] buffer;
    private int offset;
    private int limit;
    private int lastTag = 0;
    public final boolean decodeNestedMessageAsGroup;

    public ByteArrayInput(byte[] buffer, boolean decodeNestedMessageAsGroup) {
        this(buffer, 0, buffer.length, decodeNestedMessageAsGroup);
    }

    public ByteArrayInput(byte[] buffer, int offset, int len, boolean decodeNestedMessageAsGroup) {
        this.buffer = buffer;
        this.offset = offset;
        this.limit = offset + len;
        this.decodeNestedMessageAsGroup = decodeNestedMessageAsGroup;
    }

    public ByteArrayInput reset(int offset, int len) {
        if (len < 0) {
            throw new IllegalArgumentException("length cannot be negative.");
        }
        this.offset = offset;
        this.limit = offset + len;
        return this;
    }

    public int currentOffset() {
        return this.offset;
    }

    public int currentLimit() {
        return this.limit;
    }

    public int getLastTag() {
        return this.lastTag;
    }

    public int readTag() throws IOException {
        if (this.offset == this.limit) {
            this.lastTag = 0;
            return 0;
        }
        int tag = this.readRawVarint32();
        if (tag >>> 3 == 0) {
            throw ProtobufException.invalidTag();
        }
        this.lastTag = tag;
        return tag;
    }

    public void checkLastTagWas(int value) throws ProtobufException {
        if (this.lastTag != value) {
            throw ProtobufException.invalidEndTag();
        }
    }

    public boolean skipField(int tag) throws IOException {
        switch (WireFormat.getTagWireType((int)tag)) {
            case 0: {
                this.readInt32();
                return true;
            }
            case 1: {
                this.readRawLittleEndian64();
                return true;
            }
            case 2: {
                int size = this.readRawVarint32();
                if (size < 0) {
                    throw ProtobufException.negativeSize();
                }
                this.offset += size;
                return true;
            }
            case 3: {
                this.skipMessage();
                this.checkLastTagWas(WireFormat.makeTag((int)WireFormat.getTagFieldNumber((int)tag), (int)4));
                return true;
            }
            case 4: {
                return false;
            }
            case 5: {
                this.readRawLittleEndian32();
                return true;
            }
        }
        throw ProtobufException.invalidWireType();
    }

    public void skipMessage() throws IOException {
        int tag;
        while ((tag = this.readTag()) != 0 && this.skipField(tag)) {
        }
    }

    public <T> void handleUnknownField(int fieldNumber, Schema<T> schema) throws IOException {
        this.skipField(this.lastTag);
    }

    public <T> int readFieldNumber(Schema<T> schema) throws IOException {
        if (this.offset == this.limit) {
            this.lastTag = 0;
            return 0;
        }
        int tag = this.readRawVarint32();
        int fieldNumber = tag >>> 3;
        if (fieldNumber == 0) {
            if (this.decodeNestedMessageAsGroup && 7 == (tag & 7)) {
                this.lastTag = 0;
                return 0;
            }
            throw ProtobufException.invalidTag();
        }
        if (this.decodeNestedMessageAsGroup && 4 == (tag & 7)) {
            this.lastTag = 0;
            return 0;
        }
        this.lastTag = tag;
        return fieldNumber;
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readRawLittleEndian64());
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readRawLittleEndian32());
    }

    public long readUInt64() throws IOException {
        return this.readRawVarint64();
    }

    public long readInt64() throws IOException {
        return this.readRawVarint64();
    }

    public int readInt32() throws IOException {
        return this.readRawVarint32();
    }

    public long readFixed64() throws IOException {
        return this.readRawLittleEndian64();
    }

    public int readFixed32() throws IOException {
        return this.readRawLittleEndian32();
    }

    public boolean readBool() throws IOException {
        return this.buffer[this.offset++] != 0;
    }

    public int readUInt32() throws IOException {
        return this.readRawVarint32();
    }

    public int readEnum() throws IOException {
        return this.readRawVarint32();
    }

    public int readSFixed32() throws IOException {
        return this.readRawLittleEndian32();
    }

    public long readSFixed64() throws IOException {
        return this.readRawLittleEndian64();
    }

    public int readSInt32() throws IOException {
        int n = this.readRawVarint32();
        return n >>> 1 ^ -(n & 1);
    }

    public long readSInt64() throws IOException {
        long n = this.readRawVarint64();
        return n >>> 1 ^ -(n & 1L);
    }

    public String readString() throws IOException {
        int length = this.readRawVarint32();
        if (length < 0) {
            throw ProtobufException.negativeSize();
        }
        if (this.offset + length > this.limit) {
            throw ProtobufException.misreportedSize();
        }
        int offset = this.offset;
        this.offset += length;
        return StringSerializer.STRING.deser((byte[])this.buffer, (int)offset, (int)length);
    }

    public ByteString readBytes() throws IOException {
        return ByteString.wrap((byte[])this.readByteArray());
    }

    public byte[] readByteArray() throws IOException {
        int length = this.readRawVarint32();
        if (length < 0) {
            throw ProtobufException.negativeSize();
        }
        if (this.offset + length > this.limit) {
            throw ProtobufException.misreportedSize();
        }
        byte[] copy = new byte[length];
        System.arraycopy(this.buffer, this.offset, copy, 0, length);
        this.offset += length;
        return copy;
    }

    public <T> T mergeObject(T value, Schema<T> schema) throws IOException {
        if (this.decodeNestedMessageAsGroup) {
            return this.mergeObjectEncodedAsGroup(value, schema);
        }
        int length = this.readRawVarint32();
        if (length < 0) {
            throw ProtobufException.negativeSize();
        }
        int oldLimit = this.limit;
        this.limit = this.offset + length;
        if (value == null) {
            value = schema.newMessage();
        }
        schema.mergeFrom((Input)this, value);
        if (!schema.isInitialized(value)) {
            throw new UninitializedMessageException(value, schema);
        }
        this.checkLastTagWas(0);
        this.limit = oldLimit;
        return value;
    }

    <T> T mergeObjectEncodedAsGroup(T value, Schema<T> schema) throws IOException {
        if (value == null) {
            value = schema.newMessage();
        }
        schema.mergeFrom((Input)this, value);
        if (!schema.isInitialized(value)) {
            throw new UninitializedMessageException(value, schema);
        }
        this.checkLastTagWas(0);
        return value;
    }

    public int readRawVarint32() throws IOException {
        byte tmp;
        if ((tmp = this.buffer[this.offset++]) >= 0) {
            return tmp;
        }
        int result = tmp & 0x7F;
        if ((tmp = this.buffer[this.offset++]) >= 0) {
            result |= tmp << 7;
        } else {
            result |= (tmp & 0x7F) << 7;
            if ((tmp = this.buffer[this.offset++]) >= 0) {
                result |= tmp << 14;
            } else {
                result |= (tmp & 0x7F) << 14;
                if ((tmp = this.buffer[this.offset++]) >= 0) {
                    result |= tmp << 21;
                } else {
                    result |= (tmp & 0x7F) << 21;
                    tmp = this.buffer[this.offset++];
                    result |= tmp << 28;
                    if (tmp < 0) {
                        for (int i = 0; i < 5; ++i) {
                            if (this.buffer[this.offset++] < 0) continue;
                            return result;
                        }
                        throw ProtobufException.malformedVarint();
                    }
                }
            }
        }
        return result;
    }

    public long readRawVarint64() throws IOException {
        byte[] buffer = this.buffer;
        int offset = this.offset;
        long result = 0L;
        for (int shift = 0; shift < 64; shift += 7) {
            byte b = buffer[offset++];
            result |= (long)(b & 0x7F) << shift;
            if ((b & 0x80) != 0) continue;
            this.offset = offset;
            return result;
        }
        throw ProtobufException.malformedVarint();
    }

    public int readRawLittleEndian32() throws IOException {
        byte[] buffer = this.buffer;
        int offset = this.offset;
        byte b1 = buffer[offset++];
        byte b2 = buffer[offset++];
        byte b3 = buffer[offset++];
        byte b4 = buffer[offset++];
        this.offset = offset;
        return b1 & 0xFF | (b2 & 0xFF) << 8 | (b3 & 0xFF) << 16 | (b4 & 0xFF) << 24;
    }

    public long readRawLittleEndian64() throws IOException {
        byte[] buffer = this.buffer;
        int offset = this.offset;
        byte b1 = buffer[offset++];
        byte b2 = buffer[offset++];
        byte b3 = buffer[offset++];
        byte b4 = buffer[offset++];
        byte b5 = buffer[offset++];
        byte b6 = buffer[offset++];
        byte b7 = buffer[offset++];
        byte b8 = buffer[offset++];
        this.offset = offset;
        return (long)b1 & 0xFFL | ((long)b2 & 0xFFL) << 8 | ((long)b3 & 0xFFL) << 16 | ((long)b4 & 0xFFL) << 24 | ((long)b5 & 0xFFL) << 32 | ((long)b6 & 0xFFL) << 40 | ((long)b7 & 0xFFL) << 48 | ((long)b8 & 0xFFL) << 56;
    }

    public void transferByteRangeTo(Output output, boolean utf8String, int fieldNumber, boolean repeated) throws IOException {
        int length = this.readRawVarint32();
        if (length < 0) {
            throw ProtobufException.negativeSize();
        }
        output.writeByteRange(utf8String, fieldNumber, this.buffer, this.offset, length, repeated);
        this.offset += length;
    }
}

