/*
 * Decompiled with CFR 0.152.
 */
package com.github.curiousoddman.rgxgen.generator.nodes;

import com.github.curiousoddman.rgxgen.generator.nodes.Node;
import com.github.curiousoddman.rgxgen.generator.visitors.NodeVisitor;
import com.github.curiousoddman.rgxgen.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SymbolSet
implements Node {
    private static final Logger LOGGER = LoggerFactory.getLogger(SymbolSet.class);
    private static final String[] ALL_SYMBOLS = new String[95];
    private static final int SPACE_ASCII_CODE = 32;
    private static final int DEL_ASCII_CODE = 127;
    private final String[] aSymbols;

    public static String[] getAllSymbols() {
        return (String[])ALL_SYMBOLS.clone();
    }

    public SymbolSet() {
        this((String[])ALL_SYMBOLS.clone(), TYPE.POSITIVE);
    }

    public SymbolSet(String[] symbols, TYPE type) {
        this(Collections.emptyList(), symbols, type);
    }

    public SymbolSet(List<SymbolRange> symbolRanges, TYPE type) {
        this(symbolRanges, Util.ZERO_LENGTH_STRING_ARRAY, type);
    }

    public SymbolSet(List<SymbolRange> symbolRanges, String[] symbols, TYPE type) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Creating [positive = {}] from {} and {}", new Object[]{type, symbolRanges, Arrays.asList(symbols)});
        }
        ArrayList<String> initial = type == TYPE.NEGATIVE ? new ArrayList<String>(Arrays.asList(ALL_SYMBOLS)) : new ArrayList(ALL_SYMBOLS.length);
        SymbolSet.filterOrPut(initial, Arrays.asList(symbols), type);
        SymbolSet.filterOrPut(initial, symbolRanges.stream().flatMapToInt(r -> IntStream.rangeClosed(r.getFrom(), r.getTo())).mapToObj(i -> Character.valueOf((char)i)).map(Object::toString).collect(Collectors.toList()), type);
        this.aSymbols = initial.toArray(Util.ZERO_LENGTH_STRING_ARRAY);
    }

    private static void filterOrPut(Collection<String> input, List<String> symbols, TYPE type) {
        if (type == TYPE.POSITIVE) {
            input.addAll(symbols);
        } else {
            input.removeIf(symbols::contains);
        }
    }

    @Override
    public void visit(NodeVisitor visitor) {
        visitor.visit(this);
    }

    public String[] getSymbols() {
        return this.aSymbols;
    }

    public String toString() {
        return "SymbolSet{" + Arrays.toString(this.aSymbols) + '}';
    }

    static {
        for (int i = 32; i < 127; ++i) {
            SymbolSet.ALL_SYMBOLS[i - 32] = Character.valueOf((char)i).toString();
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("All symbols {} ", Arrays.asList(ALL_SYMBOLS));
        }
    }

    public static class SymbolRange {
        public static final SymbolRange SMALL_LETTERS = new SymbolRange('a', 'z');
        public static final SymbolRange CAPITAL_LETTERS = new SymbolRange('A', 'Z');
        public static final SymbolRange DIGITS = new SymbolRange('0', '9');
        private final int aFrom;
        private final int aTo;

        public SymbolRange(char from, char to) {
            this.aFrom = from;
            this.aTo = to;
        }

        int getFrom() {
            return this.aFrom;
        }

        int getTo() {
            return this.aTo;
        }

        public String toString() {
            return "SymbolRange{" + this.aFrom + ':' + this.aTo + '}';
        }
    }

    public static enum TYPE {
        POSITIVE,
        NEGATIVE;

    }
}

