/*
 * Decompiled with CFR 0.152.
 */
package com.github.curiousoddman.rgxgen.visitors;

import com.github.curiousoddman.rgxgen.config.RgxGenOption;
import com.github.curiousoddman.rgxgen.config.RgxGenProperties;
import com.github.curiousoddman.rgxgen.visitors.GenerationVisitor;
import com.github.curiousoddman.rgxgen.visitors.GenerationVisitorCaseInsensitive;
import com.github.curiousoddman.rgxgen.visitors.NotMatchingCaseInsensitiveGenerationVisitor;
import com.github.curiousoddman.rgxgen.visitors.NotMatchingGenerationVisitor;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public class GenerationVisitorBuilder {
    private final boolean aGenerateMatching;
    private Random aRandom;
    private Map<Integer, String> aGroupsValues;
    private RgxGenProperties aProperties;

    public GenerationVisitorBuilder(boolean generateMatching) {
        this.aGenerateMatching = generateMatching;
    }

    public GenerationVisitorBuilder withRandom(Random random) {
        this.aRandom = random;
        return this;
    }

    public GenerationVisitor get() {
        if (this.aRandom == null) {
            this.aRandom = new Random();
        }
        if (this.aGroupsValues == null) {
            this.aGroupsValues = new HashMap<Integer, String>();
        }
        if (this.aGenerateMatching) {
            if (RgxGenOption.CASE_INSENSITIVE.getFromProperties(this.aProperties).booleanValue()) {
                return new GenerationVisitorCaseInsensitive(this.aRandom, this.aGroupsValues, this.aProperties);
            }
            return new GenerationVisitor(this.aRandom, this.aGroupsValues, this.aProperties);
        }
        if (RgxGenOption.CASE_INSENSITIVE.getFromProperties(this.aProperties).booleanValue()) {
            return new NotMatchingCaseInsensitiveGenerationVisitor(this.aRandom, this.aGroupsValues, this.aProperties);
        }
        return new NotMatchingGenerationVisitor(this.aRandom, this.aGroupsValues, this.aProperties);
    }

    public GenerationVisitorBuilder withProperties(RgxGenProperties properties) {
        this.aProperties = properties;
        return this;
    }
}

