/*
 * Decompiled with CFR 0.152.
 */
package com.github.keran213539.commonOkHttp.utils;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpsUtils {
    private static Logger logger = LoggerFactory.getLogger(HttpsUtils.class);
    public static X509TrustManager UnSafeTrustManager = new X509TrustManager(){

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    };
    public static HostnameVerifier UnSafeHostnameVerifier = new HostnameVerifier(){

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    };

    public static SSLParams getSslSocketFactory(boolean isUnSafe) {
        return HttpsUtils.getSslSocketFactoryBase(null, null, null, isUnSafe, false, new InputStream[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SSLParams getSslSocketFactory(String certPath, String certPwd) {
        SSLParams sslParams = new SSLParams();
        FileInputStream instream = null;
        KeyStore keyStore = null;
        try {
            keyStore = KeyStore.getInstance("PKCS12");
            instream = new FileInputStream(certPath);
            char[] pwdArray = certPwd.toCharArray();
            keyStore.load(instream, pwdArray);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(keyStore, pwdArray);
            KeyManager[] kms = kmf.getKeyManagers();
            SSLContext sslContext = SSLContext.getInstance("TLSv1");
            sslContext.init(kms, null, new SecureRandom());
            sslParams.sSLSocketFactory = sslContext.getSocketFactory();
            sslParams.trustManager = UnSafeTrustManager;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                instream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return sslParams;
    }

    public static SSLParams getSslSocketFactory(X509TrustManager trustManager) {
        return HttpsUtils.getSslSocketFactoryBase(trustManager, null, null, false, true, new InputStream[0]);
    }

    public static SSLParams getSslSocketFactory(boolean isCheckHostname, InputStream ... certificates) {
        return HttpsUtils.getSslSocketFactoryBase(null, null, null, false, isCheckHostname, certificates);
    }

    public static SSLParams getSslSocketFactory(InputStream bksFile, String password, InputStream ... certificates) {
        return HttpsUtils.getSslSocketFactoryBase(null, bksFile, password, false, true, certificates);
    }

    public static SSLParams getSslSocketFactory(InputStream bksFile, String password, X509TrustManager trustManager) {
        return HttpsUtils.getSslSocketFactoryBase(trustManager, bksFile, password, false, true, new InputStream[0]);
    }

    private static SSLParams getSslSocketFactoryBase(X509TrustManager trustManager, InputStream bksFile, String password, boolean isUnSafe, boolean isCheckHostname, InputStream ... certificates) {
        SSLParams sslParams = new SSLParams();
        try {
            X509TrustManager manager;
            KeyManager[] keyManagers = HttpsUtils.prepareKeyManager(bksFile, password);
            TrustManager[] trustManagers = HttpsUtils.prepareTrustManager(certificates);
            if (trustManager != null) {
                manager = trustManager;
            } else if (trustManagers != null) {
                manager = HttpsUtils.chooseTrustManager(trustManagers);
            } else if (isUnSafe) {
                manager = UnSafeTrustManager;
            } else {
                return null;
            }
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(keyManagers, new TrustManager[]{manager}, null);
            sslParams.sSLSocketFactory = sslContext.getSocketFactory();
            sslParams.trustManager = manager;
            if (isUnSafe || !isCheckHostname) {
                sslParams.hostnameVerifier = UnSafeHostnameVerifier;
            }
            return sslParams;
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
        catch (KeyManagementException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static KeyManager[] prepareKeyManager(InputStream bksFile, String password) {
        try {
            if (bksFile == null || password == null) {
                return null;
            }
            KeyStore clientKeyStore = KeyStore.getInstance("BKS");
            clientKeyStore.load(bksFile, password.toCharArray());
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(clientKeyStore, password.toCharArray());
            return kmf.getKeyManagers();
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            return null;
        }
    }

    private static TrustManager[] prepareTrustManager(InputStream ... certificates) {
        if (certificates == null || certificates.length <= 0) {
            return null;
        }
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null);
            int index = 0;
            for (InputStream certStream : certificates) {
                String certificateAlias = Integer.toString(index++);
                Certificate cert = certificateFactory.generateCertificate(certStream);
                keyStore.setCertificateEntry(certificateAlias, cert);
                try {
                    if (certStream == null) continue;
                    certStream.close();
                }
                catch (IOException e) {
                    logger.error("", (Throwable)e);
                }
            }
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(keyStore);
            return tmf.getTrustManagers();
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            return null;
        }
    }

    private static X509TrustManager chooseTrustManager(TrustManager[] trustManagers) {
        for (TrustManager trustManager : trustManagers) {
            if (!(trustManager instanceof X509TrustManager)) continue;
            return (X509TrustManager)trustManager;
        }
        return null;
    }

    public static class SSLParams {
        public SSLSocketFactory sSLSocketFactory;
        public X509TrustManager trustManager;
        public HostnameVerifier hostnameVerifier;
    }
}

