/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.apache.http.client.protocol;

import java.io.IOException;
import wiremock.org.apache.http.HttpEntity;
import wiremock.org.apache.http.HttpEntityEnclosingRequest;
import wiremock.org.apache.http.HttpException;
import wiremock.org.apache.http.HttpRequest;
import wiremock.org.apache.http.HttpRequestInterceptor;
import wiremock.org.apache.http.HttpVersion;
import wiremock.org.apache.http.ProtocolVersion;
import wiremock.org.apache.http.annotation.Contract;
import wiremock.org.apache.http.annotation.ThreadingBehavior;
import wiremock.org.apache.http.client.config.RequestConfig;
import wiremock.org.apache.http.client.protocol.HttpClientContext;
import wiremock.org.apache.http.protocol.HttpContext;
import wiremock.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestExpectContinue
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("Expect") && request instanceof HttpEntityEnclosingRequest) {
            HttpClientContext clientContext;
            RequestConfig config;
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            if (entity != null && entity.getContentLength() != 0L && !ver.lessEquals(HttpVersion.HTTP_1_0) && (config = (clientContext = HttpClientContext.adapt(context)).getRequestConfig()).isExpectContinueEnabled()) {
                request.addHeader("Expect", "100-continue");
            }
        }
    }
}

