/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api;

import com.gs.collections.api.bag.primitive.MutableCharBag;
import com.gs.collections.api.block.function.primitive.ObjectCharToObjectFunction;
import com.gs.collections.api.block.function.primitive.CharToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.CharPredicate;
import com.gs.collections.api.block.procedure.primitive.CharProcedure;
import com.gs.collections.api.iterator.CharIterator;
import com.gs.collections.api.list.primitive.MutableCharList;
import com.gs.collections.api.set.primitive.MutableCharSet;

/**
 * CharIterable is an interface which is memory-optimized for char primitives.
 * It is inspired by the interface RichIterable, and contains a subset of the internal iterator methods on RichIterable like collect, sum, etc.
 * The API also includes an external iterator method, which returns an CharIterator. CharIterator helps iterate over the CharIterable without boxing the primitives.
 * This file was automatically generated from template file primitiveIterable.stg.
 */
public interface CharIterable extends PrimitiveIterable
{
    CharIterator charIterator();

    char[] toArray();

    boolean contains(char value);

    boolean containsAll(char... source);

    boolean containsAll(CharIterable source);

    void forEach(CharProcedure procedure);

    CharIterable select(CharPredicate predicate);

    CharIterable reject(CharPredicate predicate);

    <V> RichIterable<V> collect(CharToObjectFunction<? extends V> function);

    char detectIfNone(CharPredicate predicate, char ifNone);

    int count(CharPredicate predicate);

    boolean anySatisfy(CharPredicate predicate);

    boolean allSatisfy(CharPredicate predicate);

    boolean noneSatisfy(CharPredicate predicate);

    MutableCharList toList();

    MutableCharSet toSet();

    MutableCharBag toBag();

    LazyCharIterable asLazy();

    <T> T injectInto(T injectedValue, ObjectCharToObjectFunction<? super T, ? extends T> function);


    long sum();

    char max();

    char maxIfEmpty(char defaultValue);

    char min();

    char minIfEmpty(char defaultValue);

    double average();

    double median();

    char[] toSortedArray();

    MutableCharList toSortedList();
}
