/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.bag.primitive;

import com.gs.collections.api.ByteIterable;
import com.gs.collections.api.bag.MutableBag;
import com.gs.collections.api.block.function.primitive.ByteToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.BytePredicate;
import com.gs.collections.api.collection.primitive.MutableByteCollection;

/**
 * This file was automatically generated from template file mutablePrimitiveBag.stg.
 *
 * @since 3.0.
 */
public interface MutableByteBag extends MutableByteCollection, ByteBag
{
    void addOccurrences(byte item, int occurrences);

    boolean removeOccurrences(byte item, int occurrences);

    MutableByteBag select(BytePredicate predicate);

    MutableByteBag reject(BytePredicate predicate);

    <V> MutableBag<V> collect(ByteToObjectFunction<? extends V> function);

    MutableByteBag with(byte element);

    MutableByteBag without(byte element);

    MutableByteBag withAll(ByteIterable elements);

    MutableByteBag withoutAll(ByteIterable elements);

    MutableByteBag asUnmodifiable();

    MutableByteBag asSynchronized();

    /**
     * Returns an immutable copy of this bag.
     */
    ImmutableByteBag toImmutable();
}
