/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.factory.bag.primitive;

import com.gs.collections.api.ShortIterable;
import com.gs.collections.api.bag.primitive.ImmutableShortBag;

/**
 * A factory which creates instances of type {@link ImmutableShortBag}.
 * This file was automatically generated from template file immutablePrimitiveBagFactory.stg.
 *
 * @since 4.0.
 */
public interface ImmutableShortBagFactory
{
    /**
     * @since 6.0
     */
    ImmutableShortBag empty();

    /**
     * Same as {@link #empty()}.
     */
    ImmutableShortBag of();

    /**
     * Same as {@link #empty()}.
     */
    ImmutableShortBag with();

    /**
     * Same as {@link #with(short)}.
     */
    ImmutableShortBag of(short one);

    ImmutableShortBag with(short one);

    /**
     * Same as {@link #with(short[])}.
     */
    ImmutableShortBag of(short... items);

    ImmutableShortBag with(short... items);

    /**
     * Same as {@link #withAll(ShortIterable)}.
     */
    ImmutableShortBag ofAll(ShortIterable items);

    ImmutableShortBag withAll(ShortIterable items);
}
