/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.factory.bag.primitive;

import com.gs.collections.api.ByteIterable;
import com.gs.collections.api.bag.primitive.MutableByteBag;

/**
 * A factory which creates instances of type {@link MutableByteBag}.
 * This file was automatically generated from template file mutablePrimitiveBagFactory.stg.
 *
 * @since 6.0.
 */
public interface MutableByteBagFactory
{
    MutableByteBag empty();

    /**
     * Same as {@link #empty()}.
     */
    MutableByteBag of();

    /**
     * Same as {@link #empty()}.
     */
    MutableByteBag with();

    /**
     * Same as {@link #with(byte[])}.
     */
    MutableByteBag of(byte... items);

    MutableByteBag with(byte... items);

    /**
     * Same as {@link #withAll(ByteIterable)}.
     */
    MutableByteBag ofAll(ByteIterable items);

    MutableByteBag withAll(ByteIterable items);
}
