/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.factory.list.primitive;

import com.gs.collections.api.BooleanIterable;
import com.gs.collections.api.list.primitive.MutableBooleanList;

/**
 * A factory which creates instances of type {@link MutableBooleanList}.
 * This file was automatically generated from template file mutablePrimitiveListFactory.stg.
 *
 * @since 6.0.
 */
public interface MutableBooleanListFactory
{
    MutableBooleanList empty();

    /**
     * Same as {@link #empty()}.
     */
    MutableBooleanList of();

    /**
     * Same as {@link #empty()}.
     */
    MutableBooleanList with();

    /**
     * Same as {@link #with(boolean[])}.
     */
    MutableBooleanList of(boolean... items);

    MutableBooleanList with(boolean... items);

    /**
     * Same as {@link #withAll(BooleanIterable)}.
     */
    MutableBooleanList ofAll(BooleanIterable items);

    MutableBooleanList withAll(BooleanIterable items);
}
