/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.factory.map.primitive;

import com.gs.collections.api.map.primitive.ByteIntMap;
import com.gs.collections.api.map.primitive.ImmutableByteIntMap;

/**
 * A factory which creates instances of type {@link ImmutableByteIntMap}.
 * This file was automatically generated from template file immutablePrimitivePrimitiveMapFactory.stg.
 *
 * @since 4.0.
 */
public interface ImmutableByteIntMapFactory
{
    /**
     * @since 6.0
     */
    ImmutableByteIntMap empty();

    /**
     * Same as {@link #empty()}.
     */
    ImmutableByteIntMap of();

    /**
     * Same as {@link #empty()}.
     */
    ImmutableByteIntMap with();

    /**
     * Same as {@link #with(byte, int)}.
     */
    ImmutableByteIntMap of(byte key, int value);

    ImmutableByteIntMap with(byte key, int value);

    /**
     * Same as {@link #withAll(ByteIntMap)}.
     */
    ImmutableByteIntMap ofAll(ByteIntMap map);

    ImmutableByteIntMap withAll(ByteIntMap map);
}
