/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.factory.map.primitive;

import com.gs.collections.api.map.primitive.ImmutableObjectBooleanMap;
import com.gs.collections.api.map.primitive.ObjectBooleanMap;

/**
 * A factory which creates instances of type {@link ImmutableObjectBooleanMap}.
 * This file was automatically generated from template file immutableObjectPrimitiveMapFactory.stg.
 *
 * @since 4.0.
 */
public interface ImmutableObjectBooleanMapFactory
{
    /**
     * @since 6.0
     */
    <K> ImmutableObjectBooleanMap<K> empty();

    /**
     * Same as {@link #empty()}.
     */
    <K> ImmutableObjectBooleanMap<K> of();

    /**
     * Same as {@link #empty()}.
     */
    <K> ImmutableObjectBooleanMap<K> with();

    /**
     * Same as {@link #with(Object, boolean)}.
     */
    <K> ImmutableObjectBooleanMap<K> of(K key, boolean value);

    <K> ImmutableObjectBooleanMap<K> with(K key, boolean value);

    /**
     * Same as {@link #withAll(ObjectBooleanMap)}.
     */
    <K> ImmutableObjectBooleanMap<K> ofAll(ObjectBooleanMap<? extends K> map);

    <K> ImmutableObjectBooleanMap<K> withAll(ObjectBooleanMap<? extends K> map);
}
