/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.factory.stack.primitive;

import com.gs.collections.api.ShortIterable;
import com.gs.collections.api.stack.primitive.ImmutableShortStack;

/**
 * A factory which creates instances of type {@link ImmutableShortStack}.
 * This file was automatically generated from template file immutablePrimitiveStackFactory.stg.
 *
 * @since 4.0.
 */
public interface ImmutableShortStackFactory
{
    /**
     * @since 6.0
     */
    ImmutableShortStack empty();

    /**
     * Same as {@link #empty()}.
     */
    ImmutableShortStack of();

    /**
     * Same as {@link #empty()}.
     */
    ImmutableShortStack with();

    /**
     * Same as {@link #with(short)}.
     */
    ImmutableShortStack of(short one);

    ImmutableShortStack with(short one);

    /**
     * Same as {@link #with(short[])}.
     */
    ImmutableShortStack of(short... items);

    ImmutableShortStack with(short... items);

    /**
     * Same as {@link #withAll(ShortIterable)}.
     */
    ImmutableShortStack ofAll(ShortIterable items);

    ImmutableShortStack withAll(ShortIterable items);

    /**
     * Same as {@link #withAllReversed(ShortIterable)}.
     */
    ImmutableShortStack ofAllReversed(ShortIterable items);

    ImmutableShortStack withAllReversed(ShortIterable items);
}
