/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.factory.stack.primitive;

import com.gs.collections.api.BooleanIterable;
import com.gs.collections.api.stack.primitive.MutableBooleanStack;

/**
 * A factory which creates instances of type {@link MutableBooleanStack}.
 * This file was automatically generated from template file mutablePrimitiveStackFactory.stg.
 *
 * @since 6.0.
 */
public interface MutableBooleanStackFactory
{
    MutableBooleanStack empty();

    /**
     * Same as {@link #empty()}.
     */
    MutableBooleanStack of();

    /**
     * Same as {@link #empty()}.
     */
    MutableBooleanStack with();

    /**
     * Same as {@link #with(boolean[])}.
     */
    MutableBooleanStack of(boolean... items);

    MutableBooleanStack with(boolean... items);

    /**
     * Same as {@link #withAll(BooleanIterable)}.
     */
    MutableBooleanStack ofAll(BooleanIterable items);

    MutableBooleanStack withAll(BooleanIterable items);

    /**
     * Same as {@link #withAllReversed(BooleanIterable)}.
     */
    MutableBooleanStack ofAllReversed(BooleanIterable items);

    MutableBooleanStack withAllReversed(BooleanIterable items);
}
