/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.factory.stack.primitive;

import com.gs.collections.api.ByteIterable;
import com.gs.collections.api.stack.primitive.MutableByteStack;

/**
 * A factory which creates instances of type {@link MutableByteStack}.
 * This file was automatically generated from template file mutablePrimitiveStackFactory.stg.
 *
 * @since 6.0.
 */
public interface MutableByteStackFactory
{
    MutableByteStack empty();

    /**
     * Same as {@link #empty()}.
     */
    MutableByteStack of();

    /**
     * Same as {@link #empty()}.
     */
    MutableByteStack with();

    /**
     * Same as {@link #with(byte[])}.
     */
    MutableByteStack of(byte... items);

    MutableByteStack with(byte... items);

    /**
     * Same as {@link #withAll(ByteIterable)}.
     */
    MutableByteStack ofAll(ByteIterable items);

    MutableByteStack withAll(ByteIterable items);

    /**
     * Same as {@link #withAllReversed(ByteIterable)}.
     */
    MutableByteStack ofAllReversed(ByteIterable items);

    MutableByteStack withAllReversed(ByteIterable items);
}
