/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.factory.stack.primitive;

import com.gs.collections.api.LongIterable;
import com.gs.collections.api.stack.primitive.MutableLongStack;

/**
 * A factory which creates instances of type {@link MutableLongStack}.
 * This file was automatically generated from template file mutablePrimitiveStackFactory.stg.
 *
 * @since 6.0.
 */
public interface MutableLongStackFactory
{
    MutableLongStack empty();

    /**
     * Same as {@link #empty()}.
     */
    MutableLongStack of();

    /**
     * Same as {@link #empty()}.
     */
    MutableLongStack with();

    /**
     * Same as {@link #with(long[])}.
     */
    MutableLongStack of(long... items);

    MutableLongStack with(long... items);

    /**
     * Same as {@link #withAll(LongIterable)}.
     */
    MutableLongStack ofAll(LongIterable items);

    MutableLongStack withAll(LongIterable items);

    /**
     * Same as {@link #withAllReversed(LongIterable)}.
     */
    MutableLongStack ofAllReversed(LongIterable items);

    MutableLongStack withAllReversed(LongIterable items);
}
