/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.list.primitive;

import com.gs.collections.api.CharIterable;
import com.gs.collections.api.block.function.primitive.CharToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.CharPredicate;
import com.gs.collections.api.collection.primitive.ImmutableCharCollection;
import com.gs.collections.api.list.ImmutableList;

/**
 * This file was automatically generated from template file immutablePrimitiveList.stg.
 *
 * @since 3.0.
 */
public interface ImmutableCharList extends ImmutableCharCollection, CharList
{
    ImmutableCharList select(CharPredicate predicate);

    ImmutableCharList reject(CharPredicate predicate);

    <V> ImmutableList<V> collect(CharToObjectFunction<? extends V> function);

    ImmutableCharList newWith(char element);

    ImmutableCharList newWithout(char element);

    ImmutableCharList newWithAll(CharIterable elements);

    ImmutableCharList newWithoutAll(CharIterable elements);

    ImmutableCharList toReversed();

    /**
     * @since 6.0.
     */
    ImmutableCharList distinct();

    ImmutableCharList subList(int fromIndex, int toIndex);
}
