/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.list.primitive;

import com.gs.collections.api.IntIterable;
import com.gs.collections.api.block.function.primitive.IntToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.IntPredicate;
import com.gs.collections.api.collection.primitive.ImmutableIntCollection;
import com.gs.collections.api.list.ImmutableList;

/**
 * This file was automatically generated from template file immutablePrimitiveList.stg.
 *
 * @since 3.0.
 */
public interface ImmutableIntList extends ImmutableIntCollection, IntList
{
    ImmutableIntList select(IntPredicate predicate);

    ImmutableIntList reject(IntPredicate predicate);

    <V> ImmutableList<V> collect(IntToObjectFunction<? extends V> function);

    ImmutableIntList newWith(int element);

    ImmutableIntList newWithout(int element);

    ImmutableIntList newWithAll(IntIterable elements);

    ImmutableIntList newWithoutAll(IntIterable elements);

    ImmutableIntList toReversed();

    /**
     * @since 6.0.
     */
    ImmutableIntList distinct();

    ImmutableIntList subList(int fromIndex, int toIndex);
}
