/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.list.primitive;

import java.util.List;

import com.gs.collections.api.block.function.primitive.IntToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.IntPredicate;
import com.gs.collections.api.list.ListIterable;
import com.gs.collections.api.ordered.primitive.ReversibleIntIterable;

/**
 * This file was automatically generated from template file primitiveList.stg.
 *
 * @since 3.0.
 */
public interface IntList extends ReversibleIntIterable
{
    int get(int index);

    long dotProduct(IntList list);

    int lastIndexOf(int value);

    IntList select(IntPredicate predicate);

    IntList reject(IntPredicate predicate);

    <V> ListIterable<V> collect(IntToObjectFunction<? extends V> function);

    /**
     * Follows the same general contract as {@link List#equals(Object)}.
     */
    @Override
    boolean equals(Object o);

    /**
     * Follows the same general contract as {@link List#hashCode()}.
     */
    @Override
    int hashCode();

    /**
     * Returns an immutable copy of this list. If the list is immutable, it returns itself.
     */
    ImmutableIntList toImmutable();

    /**
     * @since 6.0.
     */
    IntList distinct();

    /**
     * @since 5.0.
     */
    IntList toReversed();

    /**
     * @see {@link List#subList(int fromIndex, int toIndex)}
     * @since 5.0.
     */
    IntList subList(int fromIndex, int toIndex);
}
