/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.list.primitive;

import com.gs.collections.api.FloatIterable;
import com.gs.collections.api.block.function.primitive.FloatToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.FloatPredicate;
import com.gs.collections.api.collection.primitive.MutableFloatCollection;
import com.gs.collections.api.list.MutableList;

/**
 * This file was automatically generated from template file mutablePrimitiveList.stg.
 *
 * @since 3.0.
 */
public interface MutableFloatList extends MutableFloatCollection, FloatList
{
    void addAtIndex(int index, float element);

    boolean addAllAtIndex(int index, float... source);

    boolean addAllAtIndex(int index, FloatIterable source);

    float removeAtIndex(int index);

    float set(int index, float element);

    MutableFloatList select(FloatPredicate predicate);

    MutableFloatList reject(FloatPredicate predicate);

    MutableFloatList with(float element);

    MutableFloatList without(float element);

    MutableFloatList withAll(FloatIterable elements);

    MutableFloatList withoutAll(FloatIterable elements);

    <V> MutableList<V> collect(FloatToObjectFunction<? extends V> function);

    MutableFloatList reverseThis();

    MutableFloatList toReversed();

    /**
     * @since 6.0.
     */
    MutableFloatList distinct();

    /**
     * Sorts this list mutating its contents and returns the same mutable list (this).
     */
    MutableFloatList sortThis();

    MutableFloatList asUnmodifiable();

    MutableFloatList asSynchronized();

    /**
     * Returns an immutable copy of this list.
     */
    ImmutableFloatList toImmutable();

    MutableFloatList subList(int fromIndex, int toIndex);
}
