/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.map.primitive;

import com.gs.collections.api.ByteIterable;
import com.gs.collections.api.block.function.primitive.ByteToBooleanFunction;
import com.gs.collections.api.block.function.primitive.BooleanFunction;
import com.gs.collections.api.block.function.primitive.BooleanFunction0;
import com.gs.collections.api.block.function.primitive.BooleanToBooleanFunction;
import com.gs.collections.api.block.predicate.primitive.ByteBooleanPredicate;

/**
 * This file was automatically generated from template file mutablePrimitivePrimitiveMap.stg.
 *
 * @since 3.0.
 */
public interface MutableByteBooleanMap extends ByteBooleanMap, MutableBooleanValuesMap
{
    void put(byte key, boolean value);

    void putAll(ByteBooleanMap map);

    void removeKey(byte key);

    void remove(byte key);

    boolean removeKeyIfAbsent(byte key, boolean value);

    boolean getIfAbsentPut(byte key, boolean value);

    boolean getIfAbsentPut(byte key, BooleanFunction0 function);

    boolean getIfAbsentPutWithKey(byte key, ByteToBooleanFunction function);

    <P> boolean getIfAbsentPutWith(byte key, BooleanFunction<? super P> function, P parameter);

    boolean updateValue(byte key, boolean initialValueIfAbsent, BooleanToBooleanFunction function);

    MutableByteBooleanMap select(ByteBooleanPredicate predicate);

    MutableByteBooleanMap reject(ByteBooleanPredicate predicate);

    MutableByteBooleanMap withKeyValue(byte key, boolean value);

    MutableByteBooleanMap withoutKey(byte key);

    MutableByteBooleanMap withoutAllKeys(ByteIterable keys);

    MutableByteBooleanMap asUnmodifiable();

    MutableByteBooleanMap asSynchronized();
}
