/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.map.primitive;

import com.gs.collections.api.CharIterable;
import com.gs.collections.api.block.function.primitive.CharToShortFunction;
import com.gs.collections.api.block.function.primitive.ShortFunction;
import com.gs.collections.api.block.function.primitive.ShortFunction0;
import com.gs.collections.api.block.function.primitive.ShortToShortFunction;
import com.gs.collections.api.block.predicate.primitive.CharShortPredicate;

/**
 * This file was automatically generated from template file mutablePrimitivePrimitiveMap.stg.
 *
 * @since 3.0.
 */
public interface MutableCharShortMap extends CharShortMap, MutableShortValuesMap
{
    void put(char key, short value);

    void putAll(CharShortMap map);

    void removeKey(char key);

    void remove(char key);

    short removeKeyIfAbsent(char key, short value);

    short getIfAbsentPut(char key, short value);

    short getIfAbsentPut(char key, ShortFunction0 function);

    short getIfAbsentPutWithKey(char key, CharToShortFunction function);

    <P> short getIfAbsentPutWith(char key, ShortFunction<? super P> function, P parameter);

    short updateValue(char key, short initialValueIfAbsent, ShortToShortFunction function);

    MutableCharShortMap select(CharShortPredicate predicate);

    MutableCharShortMap reject(CharShortPredicate predicate);

    MutableCharShortMap withKeyValue(char key, short value);

    MutableCharShortMap withoutKey(char key);

    MutableCharShortMap withoutAllKeys(CharIterable keys);

    MutableCharShortMap asUnmodifiable();

    MutableCharShortMap asSynchronized();


    short addToValue(char key, short toBeAdded);
}
