/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.map.primitive;

import com.gs.collections.api.DoubleIterable;
import com.gs.collections.api.block.function.primitive.DoubleToByteFunction;
import com.gs.collections.api.block.function.primitive.ByteFunction;
import com.gs.collections.api.block.function.primitive.ByteFunction0;
import com.gs.collections.api.block.function.primitive.ByteToByteFunction;
import com.gs.collections.api.block.predicate.primitive.DoubleBytePredicate;

/**
 * This file was automatically generated from template file mutablePrimitivePrimitiveMap.stg.
 *
 * @since 3.0.
 */
public interface MutableDoubleByteMap extends DoubleByteMap, MutableByteValuesMap
{
    void put(double key, byte value);

    void putAll(DoubleByteMap map);

    void removeKey(double key);

    void remove(double key);

    byte removeKeyIfAbsent(double key, byte value);

    byte getIfAbsentPut(double key, byte value);

    byte getIfAbsentPut(double key, ByteFunction0 function);

    byte getIfAbsentPutWithKey(double key, DoubleToByteFunction function);

    <P> byte getIfAbsentPutWith(double key, ByteFunction<? super P> function, P parameter);

    byte updateValue(double key, byte initialValueIfAbsent, ByteToByteFunction function);

    MutableDoubleByteMap select(DoubleBytePredicate predicate);

    MutableDoubleByteMap reject(DoubleBytePredicate predicate);

    MutableDoubleByteMap withKeyValue(double key, byte value);

    MutableDoubleByteMap withoutKey(double key);

    MutableDoubleByteMap withoutAllKeys(DoubleIterable keys);

    MutableDoubleByteMap asUnmodifiable();

    MutableDoubleByteMap asSynchronized();


    byte addToValue(double key, byte toBeAdded);
}
