/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.map.primitive;

import com.gs.collections.api.DoubleIterable;
import com.gs.collections.api.block.function.primitive.DoubleToCharFunction;
import com.gs.collections.api.block.function.primitive.CharFunction;
import com.gs.collections.api.block.function.primitive.CharFunction0;
import com.gs.collections.api.block.function.primitive.CharToCharFunction;
import com.gs.collections.api.block.predicate.primitive.DoubleCharPredicate;

/**
 * This file was automatically generated from template file mutablePrimitivePrimitiveMap.stg.
 *
 * @since 3.0.
 */
public interface MutableDoubleCharMap extends DoubleCharMap, MutableCharValuesMap
{
    void put(double key, char value);

    void putAll(DoubleCharMap map);

    void removeKey(double key);

    void remove(double key);

    char removeKeyIfAbsent(double key, char value);

    char getIfAbsentPut(double key, char value);

    char getIfAbsentPut(double key, CharFunction0 function);

    char getIfAbsentPutWithKey(double key, DoubleToCharFunction function);

    <P> char getIfAbsentPutWith(double key, CharFunction<? super P> function, P parameter);

    char updateValue(double key, char initialValueIfAbsent, CharToCharFunction function);

    MutableDoubleCharMap select(DoubleCharPredicate predicate);

    MutableDoubleCharMap reject(DoubleCharPredicate predicate);

    MutableDoubleCharMap withKeyValue(double key, char value);

    MutableDoubleCharMap withoutKey(double key);

    MutableDoubleCharMap withoutAllKeys(DoubleIterable keys);

    MutableDoubleCharMap asUnmodifiable();

    MutableDoubleCharMap asSynchronized();


    char addToValue(double key, char toBeAdded);
}
