/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.map.primitive;

import com.gs.collections.api.FloatIterable;
import com.gs.collections.api.block.function.Function;
import com.gs.collections.api.block.function.Function0;
import com.gs.collections.api.block.function.Function2;
import com.gs.collections.api.block.function.primitive.FloatToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.FloatObjectPredicate;

/**
 * This file was automatically generated from template file mutablePrimitiveObjectMap.stg.
 *
 * @since 3.0.
 */
public interface MutableFloatObjectMap<V> extends FloatObjectMap<V>, MutablePrimitiveObjectMap<V>
{
    V put(float key, V value);

    /**
     * @since 5.0.
     */
    void putAll(FloatObjectMap<? extends V> map);

    V removeKey(float key);

    V remove(float key);

    V getIfAbsentPut(float key, V value);

    V getIfAbsentPut(float key, Function0<? extends V> function);

    V getIfAbsentPutWithKey(float key, FloatToObjectFunction<? extends V> function);

    <P> V getIfAbsentPutWith(float key, Function<? super P, ? extends V> function, P parameter);

    /**
     * Look up the value associated with {@code key}, apply the {@code function} to it, and replace the value. If there
     * is no value associated with {@code key}, start it off with a value supplied by {@code factory}.
     */
    V updateValue(float key, Function0<? extends V> factory, Function<? super V, ? extends V> function);

    /**
     * Same as {@link #updateValue(float, Function0, Function)} with a Function2 and specified parameter which is
     * passed to the function.
     */
    <P> V updateValueWith(float key, Function0<? extends V> factory, Function2<? super V, ? super P, ? extends V> function, P parameter);

    MutableFloatObjectMap<V> select(FloatObjectPredicate<? super V> predicate);

    MutableFloatObjectMap<V> reject(FloatObjectPredicate<? super V> predicate);

    MutableFloatObjectMap<V> withKeyValue(float key, V value);

    MutableFloatObjectMap<V> withoutKey(float key);

    MutableFloatObjectMap<V> withoutAllKeys(FloatIterable keys);

    MutableFloatObjectMap<V> asUnmodifiable();

    MutableFloatObjectMap<V> asSynchronized();
}
