/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.map.primitive;

import com.gs.collections.api.IntIterable;
import com.gs.collections.api.block.function.primitive.IntToBooleanFunction;
import com.gs.collections.api.block.function.primitive.BooleanFunction;
import com.gs.collections.api.block.function.primitive.BooleanFunction0;
import com.gs.collections.api.block.function.primitive.BooleanToBooleanFunction;
import com.gs.collections.api.block.predicate.primitive.IntBooleanPredicate;

/**
 * This file was automatically generated from template file mutablePrimitivePrimitiveMap.stg.
 *
 * @since 3.0.
 */
public interface MutableIntBooleanMap extends IntBooleanMap, MutableBooleanValuesMap
{
    void put(int key, boolean value);

    void putAll(IntBooleanMap map);

    void removeKey(int key);

    void remove(int key);

    boolean removeKeyIfAbsent(int key, boolean value);

    boolean getIfAbsentPut(int key, boolean value);

    boolean getIfAbsentPut(int key, BooleanFunction0 function);

    boolean getIfAbsentPutWithKey(int key, IntToBooleanFunction function);

    <P> boolean getIfAbsentPutWith(int key, BooleanFunction<? super P> function, P parameter);

    boolean updateValue(int key, boolean initialValueIfAbsent, BooleanToBooleanFunction function);

    MutableIntBooleanMap select(IntBooleanPredicate predicate);

    MutableIntBooleanMap reject(IntBooleanPredicate predicate);

    MutableIntBooleanMap withKeyValue(int key, boolean value);

    MutableIntBooleanMap withoutKey(int key);

    MutableIntBooleanMap withoutAllKeys(IntIterable keys);

    MutableIntBooleanMap asUnmodifiable();

    MutableIntBooleanMap asSynchronized();
}
