/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.map.primitive;

import com.gs.collections.api.LongIterable;
import com.gs.collections.api.block.function.primitive.LongToByteFunction;
import com.gs.collections.api.block.function.primitive.ByteFunction;
import com.gs.collections.api.block.function.primitive.ByteFunction0;
import com.gs.collections.api.block.function.primitive.ByteToByteFunction;
import com.gs.collections.api.block.predicate.primitive.LongBytePredicate;

/**
 * This file was automatically generated from template file mutablePrimitivePrimitiveMap.stg.
 *
 * @since 3.0.
 */
public interface MutableLongByteMap extends LongByteMap, MutableByteValuesMap
{
    void put(long key, byte value);

    void putAll(LongByteMap map);

    void removeKey(long key);

    void remove(long key);

    byte removeKeyIfAbsent(long key, byte value);

    byte getIfAbsentPut(long key, byte value);

    byte getIfAbsentPut(long key, ByteFunction0 function);

    byte getIfAbsentPutWithKey(long key, LongToByteFunction function);

    <P> byte getIfAbsentPutWith(long key, ByteFunction<? super P> function, P parameter);

    byte updateValue(long key, byte initialValueIfAbsent, ByteToByteFunction function);

    MutableLongByteMap select(LongBytePredicate predicate);

    MutableLongByteMap reject(LongBytePredicate predicate);

    MutableLongByteMap withKeyValue(long key, byte value);

    MutableLongByteMap withoutKey(long key);

    MutableLongByteMap withoutAllKeys(LongIterable keys);

    MutableLongByteMap asUnmodifiable();

    MutableLongByteMap asSynchronized();


    byte addToValue(long key, byte toBeAdded);
}
