/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.map.primitive;

import com.gs.collections.api.LongIterable;
import com.gs.collections.api.block.function.primitive.LongToDoubleFunction;
import com.gs.collections.api.block.function.primitive.DoubleFunction;
import com.gs.collections.api.block.function.primitive.DoubleFunction0;
import com.gs.collections.api.block.function.primitive.DoubleToDoubleFunction;
import com.gs.collections.api.block.predicate.primitive.LongDoublePredicate;

/**
 * This file was automatically generated from template file mutablePrimitivePrimitiveMap.stg.
 *
 * @since 3.0.
 */
public interface MutableLongDoubleMap extends LongDoubleMap, MutableDoubleValuesMap
{
    void put(long key, double value);

    void putAll(LongDoubleMap map);

    void removeKey(long key);

    void remove(long key);

    double removeKeyIfAbsent(long key, double value);

    double getIfAbsentPut(long key, double value);

    double getIfAbsentPut(long key, DoubleFunction0 function);

    double getIfAbsentPutWithKey(long key, LongToDoubleFunction function);

    <P> double getIfAbsentPutWith(long key, DoubleFunction<? super P> function, P parameter);

    double updateValue(long key, double initialValueIfAbsent, DoubleToDoubleFunction function);

    MutableLongDoubleMap select(LongDoublePredicate predicate);

    MutableLongDoubleMap reject(LongDoublePredicate predicate);

    MutableLongDoubleMap withKeyValue(long key, double value);

    MutableLongDoubleMap withoutKey(long key);

    MutableLongDoubleMap withoutAllKeys(LongIterable keys);

    MutableLongDoubleMap asUnmodifiable();

    MutableLongDoubleMap asSynchronized();


    double addToValue(long key, double toBeAdded);
}
