/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.map.primitive;

import com.gs.collections.api.LongIterable;
import com.gs.collections.api.block.function.primitive.LongFunction;
import com.gs.collections.api.block.function.primitive.LongFunction0;
import com.gs.collections.api.block.function.primitive.LongToLongFunction;
import com.gs.collections.api.block.predicate.primitive.LongLongPredicate;

/**
 * This file was automatically generated from template file mutablePrimitivePrimitiveMap.stg.
 *
 * @since 3.0.
 */
public interface MutableLongLongMap extends LongLongMap, MutableLongValuesMap
{
    void put(long key, long value);

    void putAll(LongLongMap map);

    void removeKey(long key);

    void remove(long key);

    long removeKeyIfAbsent(long key, long value);

    long getIfAbsentPut(long key, long value);

    long getIfAbsentPut(long key, LongFunction0 function);

    long getIfAbsentPutWithKey(long key, LongToLongFunction function);

    <P> long getIfAbsentPutWith(long key, LongFunction<? super P> function, P parameter);

    long updateValue(long key, long initialValueIfAbsent, LongToLongFunction function);

    MutableLongLongMap select(LongLongPredicate predicate);

    MutableLongLongMap reject(LongLongPredicate predicate);

    MutableLongLongMap withKeyValue(long key, long value);

    MutableLongLongMap withoutKey(long key);

    MutableLongLongMap withoutAllKeys(LongIterable keys);

    MutableLongLongMap asUnmodifiable();

    MutableLongLongMap asSynchronized();


    long addToValue(long key, long toBeAdded);
}
