/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.map.primitive;

import com.gs.collections.api.LongIterable;
import com.gs.collections.api.block.function.primitive.LongToShortFunction;
import com.gs.collections.api.block.function.primitive.ShortFunction;
import com.gs.collections.api.block.function.primitive.ShortFunction0;
import com.gs.collections.api.block.function.primitive.ShortToShortFunction;
import com.gs.collections.api.block.predicate.primitive.LongShortPredicate;

/**
 * This file was automatically generated from template file mutablePrimitivePrimitiveMap.stg.
 *
 * @since 3.0.
 */
public interface MutableLongShortMap extends LongShortMap, MutableShortValuesMap
{
    void put(long key, short value);

    void putAll(LongShortMap map);

    void removeKey(long key);

    void remove(long key);

    short removeKeyIfAbsent(long key, short value);

    short getIfAbsentPut(long key, short value);

    short getIfAbsentPut(long key, ShortFunction0 function);

    short getIfAbsentPutWithKey(long key, LongToShortFunction function);

    <P> short getIfAbsentPutWith(long key, ShortFunction<? super P> function, P parameter);

    short updateValue(long key, short initialValueIfAbsent, ShortToShortFunction function);

    MutableLongShortMap select(LongShortPredicate predicate);

    MutableLongShortMap reject(LongShortPredicate predicate);

    MutableLongShortMap withKeyValue(long key, short value);

    MutableLongShortMap withoutKey(long key);

    MutableLongShortMap withoutAllKeys(LongIterable keys);

    MutableLongShortMap asUnmodifiable();

    MutableLongShortMap asSynchronized();


    short addToValue(long key, short toBeAdded);
}
