/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.map.primitive;

import com.gs.collections.api.ShortIterable;
import com.gs.collections.api.block.function.Function;
import com.gs.collections.api.block.function.Function0;
import com.gs.collections.api.block.function.Function2;
import com.gs.collections.api.block.function.primitive.ShortToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.ShortObjectPredicate;

/**
 * This file was automatically generated from template file mutablePrimitiveObjectMap.stg.
 *
 * @since 3.0.
 */
public interface MutableShortObjectMap<V> extends ShortObjectMap<V>, MutablePrimitiveObjectMap<V>
{
    V put(short key, V value);

    /**
     * @since 5.0.
     */
    void putAll(ShortObjectMap<? extends V> map);

    V removeKey(short key);

    V remove(short key);

    V getIfAbsentPut(short key, V value);

    V getIfAbsentPut(short key, Function0<? extends V> function);

    V getIfAbsentPutWithKey(short key, ShortToObjectFunction<? extends V> function);

    <P> V getIfAbsentPutWith(short key, Function<? super P, ? extends V> function, P parameter);

    /**
     * Look up the value associated with {@code key}, apply the {@code function} to it, and replace the value. If there
     * is no value associated with {@code key}, start it off with a value supplied by {@code factory}.
     */
    V updateValue(short key, Function0<? extends V> factory, Function<? super V, ? extends V> function);

    /**
     * Same as {@link #updateValue(short, Function0, Function)} with a Function2 and specified parameter which is
     * passed to the function.
     */
    <P> V updateValueWith(short key, Function0<? extends V> factory, Function2<? super V, ? super P, ? extends V> function, P parameter);

    MutableShortObjectMap<V> select(ShortObjectPredicate<? super V> predicate);

    MutableShortObjectMap<V> reject(ShortObjectPredicate<? super V> predicate);

    MutableShortObjectMap<V> withKeyValue(short key, V value);

    MutableShortObjectMap<V> withoutKey(short key);

    MutableShortObjectMap<V> withoutAllKeys(ShortIterable keys);

    MutableShortObjectMap<V> asUnmodifiable();

    MutableShortObjectMap<V> asSynchronized();
}
