/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.jsr305;

import edu.umd.cs.findbugs.ba.jsr305.TypeQualifierValue;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectlyRelevantTypeQualifiersDatabase {
    private Map<MethodDescriptor, Collection<TypeQualifierValue>> methodToDirectlyRelevantQualifiersMap = new HashMap<MethodDescriptor, Collection<TypeQualifierValue>>();
    private Set<TypeQualifierValue> allKnownQualifiers = new HashSet<TypeQualifierValue>();

    public Collection<TypeQualifierValue> getDirectlyRelevantTypeQualifiers(MethodDescriptor m) {
        Collection<TypeQualifierValue> result = this.methodToDirectlyRelevantQualifiersMap.get(m);
        if (result != null) {
            return result;
        }
        return Collections.emptyList();
    }

    public Set<TypeQualifierValue> getAllKnownQualifiers() {
        return Collections.unmodifiableSet(this.allKnownQualifiers);
    }

    public void setDirectlyRelevantTypeQualifiers(MethodDescriptor methodDescriptor, Collection<TypeQualifierValue> qualifiers) {
        this.methodToDirectlyRelevantQualifiersMap.put(methodDescriptor, qualifiers);
        this.allKnownQualifiers.addAll(qualifiers);
    }
}

