/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.npe2;

import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Edge;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.npe2.Condition;
import edu.umd.cs.findbugs.ba.npe2.Decision;
import edu.umd.cs.findbugs.ba.npe2.DefinitelyNullSet;
import edu.umd.cs.findbugs.ba.npe2.NullnessValue;
import edu.umd.cs.findbugs.ba.vna.ValueNumber;
import edu.umd.cs.findbugs.ba.vna.ValueNumberFrame;

public class IfNullCondition
extends Condition {
    private ValueNumber valueNumber;
    private Decision ifcmpDecision;
    private Decision fallThroughDecision;

    public IfNullCondition(Location location) {
        super(location);
    }

    public Decision getDecision(Edge edge) {
        return edge.getType() == 1 ? this.ifcmpDecision : this.fallThroughDecision;
    }

    public ValueNumber getValueNumber() {
        return this.valueNumber;
    }

    public void refresh(ValueNumberFrame vnaFrame, DefinitelyNullSet definitelyNullSet) throws DataflowAnalysisException {
        this.valueNumber = (ValueNumber)vnaFrame.getTopValue();
        NullnessValue nullnessValue = definitelyNullSet.getNulllessValue(this.valueNumber);
        short opcode = this.getLocation().getHandle().getInstruction().getOpcode();
        if (nullnessValue.isDefinitelyNull() || nullnessValue.isDefinitelyNotNull()) {
            boolean ifcmpFeasible = nullnessValue.isDefinitelyNull() == (opcode == 198);
            this.ifcmpDecision = new Decision(ifcmpFeasible, ifcmpFeasible ? nullnessValue.toCheckedValue() : null);
            boolean fallThroughFeasible = nullnessValue.isDefinitelyNull() != (opcode == 199);
            this.fallThroughDecision = new Decision(fallThroughFeasible, fallThroughFeasible ? nullnessValue.toCheckedValue() : null);
            return;
        }
        NullnessValue definitelyNull = NullnessValue.definitelyNullValue().toCheckedValue();
        NullnessValue definitelyNotNull = NullnessValue.definitelyNotNullValue().toCheckedValue();
        this.ifcmpDecision = new Decision(true, opcode == 198 ? definitelyNull : definitelyNotNull);
        this.fallThroughDecision = new Decision(true, opcode == 198 ? definitelyNotNull : definitelyNull);
    }
}

