/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.FindBugsMain;
import edu.umd.cs.findbugs.Plugin;
import edu.umd.cs.findbugs.Version;
import java.util.TreeSet;

public class ShowHelp {
    public static void main(String[] args) {
        System.out.println("FindBugs version " + Version.RELEASE + ", " + "http://findbugs.sourceforge.net");
        DetectorFactoryCollection.instance();
        System.out.println("Command line options");
        TreeSet<FindBugsMain> cmds = new TreeSet<FindBugsMain>();
        for (Plugin p : Plugin.getAllPlugins()) {
            for (FindBugsMain m : p.getAllFindBugsMain()) {
                cmds.add(m);
            }
        }
        for (FindBugsMain m : cmds) {
            System.out.printf("fb %-12s %-12s %s%n", m.cmd, m.kind, m.description);
        }
        System.out.println();
        ShowHelp.showGeneralOptions();
    }

    public static void showSynopsis() {
        System.out.println("Usage: findbugs [general options] [gui options]");
    }

    public static void showGeneralOptions() {
        System.out.println("General options:");
        System.out.println("  -jvmArgs args    Pass args to JVM");
        System.out.println("  -maxHeap size    Maximum Java heap size in megabytes (default=768)");
        System.out.println("  -javahome <dir>  Specify location of JRE");
    }
}

