/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.ClassAnnotation;
import edu.umd.cs.findbugs.ClassWarningSuppressor;
import edu.umd.cs.findbugs.PackageWarningSuppressor;
import edu.umd.cs.findbugs.WarningSuppressor;
import edu.umd.cs.findbugs.filter.Matcher;
import edu.umd.cs.findbugs.xml.XMLOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class SuppressionMatcher
implements Matcher {
    private final Map<ClassAnnotation, Collection<WarningSuppressor>> suppressedWarnings = new HashMap<ClassAnnotation, Collection<WarningSuppressor>>();
    private final Map<String, Collection<WarningSuppressor>> suppressedPackageWarnings = new HashMap<String, Collection<WarningSuppressor>>();
    int count = 0;

    public void addPackageSuppressor(PackageWarningSuppressor suppressor) {
        String packageName = suppressor.getPackageName();
        Collection<WarningSuppressor> c = this.suppressedPackageWarnings.get(packageName);
        if (c == null) {
            c = new LinkedList<WarningSuppressor>();
            this.suppressedPackageWarnings.put(packageName, c);
        }
        c.add(suppressor);
    }

    public void addSuppressor(ClassWarningSuppressor suppressor) {
        ClassAnnotation clazz = suppressor.getClassAnnotation().getTopLevelClass();
        Collection<WarningSuppressor> c = this.suppressedWarnings.get(clazz);
        if (c == null) {
            c = new LinkedList<WarningSuppressor>();
            this.suppressedWarnings.put(clazz, c);
        }
        c.add(suppressor);
    }

    public int count() {
        return this.count;
    }

    @Override
    public boolean match(BugInstance b) {
        ClassAnnotation clazz = b.getPrimaryClass().getTopLevelClass();
        Collection<WarningSuppressor> c = this.suppressedWarnings.get(clazz);
        if (c != null) {
            for (WarningSuppressor warningSuppressor : c) {
                if (!warningSuppressor.match(b)) continue;
                ++this.count;
                return true;
            }
        }
        for (Collection collection : this.suppressedPackageWarnings.values()) {
            for (WarningSuppressor w : collection) {
                if (!w.match(b)) continue;
                ++this.count;
                return true;
            }
        }
        return false;
    }

    @Override
    public void writeXML(XMLOutput xmlOutput, boolean disabled) throws IOException {
    }
}

