/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.charsets;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import javax.annotation.WillCloseWhenClosed;

public class UTF8 {
    private static final String UTF_8 = "UTF-8";
    public static final Charset charset = Charset.forName("UTF-8");

    public static PrintStream printStream(OutputStream out) {
        return UTF8.printStream(out, false);
    }

    public static PrintStream printStream(OutputStream out, boolean autoflush) {
        try {
            return new PrintStream(out, autoflush, UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)"UTF-8 not supported");
        }
    }

    public static Writer writer(OutputStream out) {
        return new OutputStreamWriter(out, charset);
    }

    public static Writer fileWriter(File fileName) throws IOException {
        return new OutputStreamWriter((OutputStream)new FileOutputStream(fileName), charset);
    }

    public static BufferedWriter bufferedWriter(File fileName) throws IOException {
        return new BufferedWriter(UTF8.fileWriter(fileName));
    }

    public static PrintWriter printWriter(File fileName) throws IOException {
        return new PrintWriter(UTF8.bufferedWriter(fileName));
    }

    public static PrintWriter printWriter(PrintStream printStream) {
        try {
            return new PrintWriter(new OutputStreamWriter((OutputStream)printStream, UTF_8));
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)"UTF-8 not supported");
        }
    }

    public static PrintWriter printWriter(PrintStream printStream, boolean autoflush) {
        try {
            return new PrintWriter((Writer)new OutputStreamWriter((OutputStream)printStream, UTF_8), autoflush);
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)"UTF-8 not supported");
        }
    }

    public static Writer fileWriter(String fileName) throws IOException {
        return new OutputStreamWriter((OutputStream)new FileOutputStream(fileName), charset);
    }

    public static BufferedWriter bufferedWriter(String fileName) throws IOException {
        return new BufferedWriter(UTF8.fileWriter(fileName));
    }

    public static Reader fileReader(String fileName) throws IOException {
        return UTF8.reader(new FileInputStream(fileName));
    }

    public static Reader fileReader(File fileName) throws IOException {
        return UTF8.reader(new FileInputStream(fileName));
    }

    public static PrintWriter printWriter(String fileName) throws IOException {
        return new PrintWriter(UTF8.bufferedWriter(fileName));
    }

    public static Reader reader(@WillCloseWhenClosed InputStream in) {
        return new InputStreamReader(in, charset);
    }

    public static BufferedReader bufferedReader(@WillCloseWhenClosed InputStream in) {
        return new BufferedReader(UTF8.reader(in));
    }

    public static byte[] getBytes(String s) {
        return charset.encode(s).array();
    }
}

